<?php

namespace dgsoft\EnumType;

/**
 * This class stands for CarProviderTypeEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgCarProviderTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'AmadeusProvider'
     * @return string 'AmadeusProvider'
     */
    const VALUE_AMADEUS_PROVIDER = 'AmadeusProvider';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_AMADEUS_PROVIDER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_AMADEUS_PROVIDER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
