<?php

namespace dgsoft\EnumType;

/**
 * This class stands for AllianceCode EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgAllianceCode
{
    /**
     * Constant for value 'ONEWORLD'
     * @return string 'ONEWORLD'
     */
    const VALUE_ONEWORLD = 'ONEWORLD';
    /**
     * Constant for value 'SKYTEAM'
     * @return string 'SKYTEAM'
     */
    const VALUE_SKYTEAM = 'SKYTEAM';
    /**
     * Constant for value 'STAR_ALLIANCE'
     * @return string 'STAR_ALLIANCE'
     */
    const VALUE_STAR_ALLIANCE = 'STAR_ALLIANCE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONEWORLD
     * @uses self::VALUE_SKYTEAM
     * @uses self::VALUE_STAR_ALLIANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONEWORLD,
            self::VALUE_SKYTEAM,
            self::VALUE_STAR_ALLIANCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
