<?php

namespace dgsoft\EnumType;

/**
 * This class stands for AirlineDiversityEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgAirlineDiversityEnum
{
    /**
     * Constant for value 'ADC'
     * @return string 'ADC'
     */
    const VALUE_ADC = 'ADC';
    /**
     * Constant for value 'NAD'
     * @return string 'NAD'
     */
    const VALUE_NAD = 'NAD';
    /**
     * Constant for value 'NDD'
     * @return string 'NDD'
     */
    const VALUE_NDD = 'NDD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADC
     * @uses self::VALUE_NAD
     * @uses self::VALUE_NDD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADC,
            self::VALUE_NAD,
            self::VALUE_NDD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
