<?php

namespace dgsoft;

/**
 * Class which returns the class map definition
 * @package Dg
 */
class DgClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Ping' => '\\dgsoft\\StructType\\DgPing',
            'OTA_PingRQ' => '\\dgsoft\\StructType\\DgOTA_PingRQ',
            'PingResponse' => '\\dgsoft\\StructType\\DgPingResponse',
            'OTA_PingRS' => '\\dgsoft\\StructType\\DgOTA_PingRS',
            'ErrorsType' => '\\dgsoft\\StructType\\DgErrorsType',
            'ErrorType' => '\\dgsoft\\StructType\\DgErrorType',
            'FreeTextType' => '\\dgsoft\\StructType\\DgFreeTextType',
            'WarningType' => '\\dgsoft\\StructType\\DgWarningType',
            'WarningsType' => '\\dgsoft\\StructType\\DgWarningsType',
            'SuccessType' => '\\dgsoft\\StructType\\DgSuccessType',
            'AuthenticationSoapHeader' => '\\dgsoft\\StructType\\DgAuthenticationSoapHeader',
            'GenericSoapHeader' => '\\dgsoft\\StructType\\DgGenericSoapHeader',
            'SignOut' => '\\dgsoft\\StructType\\DgSignOut',
            'SignOutResponse' => '\\dgsoft\\StructType\\DgSignOutResponse',
            'CurrencyConversion' => '\\dgsoft\\StructType\\DgCurrencyConversion',
            'OTA_CurrencyConversionRQ' => '\\dgsoft\\StructType\\DgOTA_CurrencyConversionRQ',
            'CurrencyConversionResponse' => '\\dgsoft\\StructType\\DgCurrencyConversionResponse',
            'OTA_CurrencyConversionRS' => '\\dgsoft\\StructType\\DgOTA_CurrencyConversionRS',
            'Cancel' => '\\dgsoft\\StructType\\DgCancel',
            'OTA_CancelRQ' => '\\dgsoft\\StructType\\DgOTA_CancelRQ',
            'UniqueID' => '\\dgsoft\\StructType\\DgUniqueID',
            'Segment' => '\\dgsoft\\StructType\\DgSegment',
            'CancellationOverrides' => '\\dgsoft\\StructType\\DgCancellationOverrides',
            'UniqueID_Type' => '\\dgsoft\\StructType\\DgUniqueID_Type',
            'CompanyNameType' => '\\dgsoft\\StructType\\DgCompanyNameType',
            'TravelArrangerType' => '\\dgsoft\\StructType\\DgTravelArrangerType',
            'CompanyNamePrefType' => '\\dgsoft\\StructType\\DgCompanyNamePrefType',
            'OperatingAirlineType' => '\\dgsoft\\StructType\\DgOperatingAirlineType',
            'ArrayOfSourceType' => '\\dgsoft\\ArrayType\\DgArrayOfSourceType',
            'SourceType' => '\\dgsoft\\StructType\\DgSourceType',
            'RequestorID' => '\\dgsoft\\StructType\\DgRequestorID',
            'Position' => '\\dgsoft\\StructType\\DgPosition',
            'BookingChannel' => '\\dgsoft\\StructType\\DgBookingChannel',
            'VerificationType' => '\\dgsoft\\StructType\\DgVerificationType',
            'PersonName' => '\\dgsoft\\StructType\\DgPersonName',
            'TelephoneInfo' => '\\dgsoft\\StructType\\DgTelephoneInfo',
            'CustLoyalty' => '\\dgsoft\\StructType\\DgCustLoyalty',
            'ReservationTimeSpan' => '\\dgsoft\\StructType\\DgReservationTimeSpan',
            'AssociatedQuantity' => '\\dgsoft\\StructType\\DgAssociatedQuantity',
            'StartLocation' => '\\dgsoft\\StructType\\DgStartLocation',
            'EndLocation' => '\\dgsoft\\StructType\\DgEndLocation',
            'PersonNameType' => '\\dgsoft\\StructType\\DgPersonNameType',
            'EmailType' => '\\dgsoft\\StructType\\DgEmailType',
            'PaymentCardType' => '\\dgsoft\\StructType\\DgPaymentCardType',
            'CardIssuerName' => '\\dgsoft\\StructType\\DgCardIssuerName',
            'AddressType' => '\\dgsoft\\StructType\\DgAddressType',
            'StreetNmbr' => '\\dgsoft\\StructType\\DgStreetNmbr',
            'BldgRoom' => '\\dgsoft\\StructType\\DgBldgRoom',
            'StreetNmbrType' => '\\dgsoft\\StructType\\DgStreetNmbrType',
            'StateProvType' => '\\dgsoft\\StructType\\DgStateProvType',
            'CountryNameType' => '\\dgsoft\\StructType\\DgCountryNameType',
            'OffLocationServiceCoreTypeAddress' => '\\dgsoft\\StructType\\DgOffLocationServiceCoreTypeAddress',
            'VehicleVendorAddressType' => '\\dgsoft\\StructType\\DgVehicleVendorAddressType',
            'AddressInfoType' => '\\dgsoft\\StructType\\DgAddressInfoType',
            'LocationType' => '\\dgsoft\\StructType\\DgLocationType',
            'VehicleLocationAdditionalDetailsTypeOneWayDropLocation' => '\\dgsoft\\StructType\\DgVehicleLocationAdditionalDetailsTypeOneWayDropLocation',
            'VehicleRentalCoreTypeReturnLocation' => '\\dgsoft\\StructType\\DgVehicleRentalCoreTypeReturnLocation',
            'VehicleRentalCoreTypePickUpLocation' => '\\dgsoft\\StructType\\DgVehicleRentalCoreTypePickUpLocation',
            'AirportPrefType' => '\\dgsoft\\StructType\\DgAirportPrefType',
            'TPA_ExtensionsType' => '\\dgsoft\\StructType\\DgTPA_ExtensionsType',
            'CancelRuleType' => '\\dgsoft\\StructType\\DgCancelRuleType',
            'ArrayOfFreeTextType' => '\\dgsoft\\ArrayType\\DgArrayOfFreeTextType',
            'CancelResponse' => '\\dgsoft\\StructType\\DgCancelResponse',
            'OTA_CancelRS' => '\\dgsoft\\StructType\\DgOTA_CancelRS',
            'OTA_AirBookRS' => '\\dgsoft\\StructType\\DgOTA_AirBookRS',
            'AirReservation' => '\\dgsoft\\StructType\\DgAirReservation',
            'OTA_HotelResRS' => '\\dgsoft\\StructType\\DgOTA_HotelResRS',
            'HotelPriceChangeInfo' => '\\dgsoft\\StructType\\DgHotelPriceChangeInfo',
            'HotelReservationsType' => '\\dgsoft\\StructType\\DgHotelReservationsType',
            'HotelReservationType' => '\\dgsoft\\StructType\\DgHotelReservationType',
            'HotelStay' => '\\dgsoft\\StructType\\DgHotelStay',
            'Areas' => '\\dgsoft\\StructType\\DgAreas',
            'Queue' => '\\dgsoft\\StructType\\DgQueue',
            'ArrayOfOTA_HotelAvailRSRoomStaysRoomStay' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay',
            'RoomStay' => '\\dgsoft\\StructType\\DgRoomStay',
            'Reference' => '\\dgsoft\\StructType\\DgReference',
            'RoomStayType' => '\\dgsoft\\StructType\\DgRoomStayType',
            'RoomRates' => '\\dgsoft\\StructType\\DgRoomRates',
            'RoomRate' => '\\dgsoft\\StructType\\DgRoomRate',
            'AdvanceBookingRestriction' => '\\dgsoft\\StructType\\DgAdvanceBookingRestriction',
            'ArrayOfRoomTypeType' => '\\dgsoft\\ArrayType\\DgArrayOfRoomTypeType',
            'RoomTypeType' => '\\dgsoft\\StructType\\DgRoomTypeType',
            'ParagraphType' => '\\dgsoft\\StructType\\DgParagraphType',
            'ParagraphTypeListItem' => '\\dgsoft\\StructType\\DgParagraphTypeListItem',
            'FormattedTextTextType' => '\\dgsoft\\StructType\\DgFormattedTextTextType',
            'CoverageDetailsType' => '\\dgsoft\\StructType\\DgCoverageDetailsType',
            'RateQualifierTypeRateComment' => '\\dgsoft\\StructType\\DgRateQualifierTypeRateComment',
            'ArrayOfAdditionalDetailType' => '\\dgsoft\\ArrayType\\DgArrayOfAdditionalDetailType',
            'AdditionalDetailType' => '\\dgsoft\\StructType\\DgAdditionalDetailType',
            'ArrayOfRoomAmenityPrefType' => '\\dgsoft\\ArrayType\\DgArrayOfRoomAmenityPrefType',
            'RoomAmenityPrefType' => '\\dgsoft\\StructType\\DgRoomAmenityPrefType',
            'ArrayOfRatePlanType' => '\\dgsoft\\ArrayType\\DgArrayOfRatePlanType',
            'RatePlanType' => '\\dgsoft\\StructType\\DgRatePlanType',
            'RatePlanInclusion' => '\\dgsoft\\StructType\\DgRatePlanInclusion',
            'MealsIncluded' => '\\dgsoft\\StructType\\DgMealsIncluded',
            'RestrictionStatus' => '\\dgsoft\\StructType\\DgRestrictionStatus',
            'Deadline' => '\\dgsoft\\StructType\\DgDeadline',
            'ArrayOfGuaranteeTypeGuaranteeAccepted' => '\\dgsoft\\ArrayType\\DgArrayOfGuaranteeTypeGuaranteeAccepted',
            'GuaranteeAccepted' => '\\dgsoft\\StructType\\DgGuaranteeAccepted',
            'PaymentFormType' => '\\dgsoft\\StructType\\DgPaymentFormType',
            'LoyaltyRedemption' => '\\dgsoft\\StructType\\DgLoyaltyRedemption',
            'LoyaltyCertificate' => '\\dgsoft\\StructType\\DgLoyaltyCertificate',
            'Voucher' => '\\dgsoft\\StructType\\DgVoucher',
            'MiscChargeOrder' => '\\dgsoft\\StructType\\DgMiscChargeOrder',
            'Cash' => '\\dgsoft\\StructType\\DgCash',
            'BankAcctType' => '\\dgsoft\\StructType\\DgBankAcctType',
            'DirectBillType' => '\\dgsoft\\StructType\\DgDirectBillType',
            'CompanyName' => '\\dgsoft\\StructType\\DgCompanyName',
            'PaymentDetailType' => '\\dgsoft\\StructType\\DgPaymentDetailType',
            'PaymentAmount' => '\\dgsoft\\StructType\\DgPaymentAmount',
            'ArrayOfCommentTypeComment' => '\\dgsoft\\ArrayType\\DgArrayOfCommentTypeComment',
            'Comment' => '\\dgsoft\\StructType\\DgComment',
            'CancelPenaltiesType' => '\\dgsoft\\StructType\\DgCancelPenaltiesType',
            'CancelPenaltyType' => '\\dgsoft\\StructType\\DgCancelPenaltyType',
            'AmountPercentType' => '\\dgsoft\\StructType\\DgAmountPercentType',
            'TaxesType' => '\\dgsoft\\StructType\\DgTaxesType',
            'TaxType' => '\\dgsoft\\StructType\\DgTaxType',
            'CommissionType' => '\\dgsoft\\StructType\\DgCommissionType',
            'CommissionableAmount' => '\\dgsoft\\StructType\\DgCommissionableAmount',
            'PrepaidAmount' => '\\dgsoft\\StructType\\DgPrepaidAmount',
            'FlatCommission' => '\\dgsoft\\StructType\\DgFlatCommission',
            'CommissionPayableAmount' => '\\dgsoft\\StructType\\DgCommissionPayableAmount',
            'RoomRateType' => '\\dgsoft\\StructType\\DgRoomRateType',
            'Availability' => '\\dgsoft\\StructType\\DgAvailability',
            'ArrayOfRateTypeRate' => '\\dgsoft\\ArrayType\\DgArrayOfRateTypeRate',
            'Rate' => '\\dgsoft\\StructType\\DgRate',
            'AmountType' => '\\dgsoft\\StructType\\DgAmountType',
            'AdditionalGuestAmounts' => '\\dgsoft\\StructType\\DgAdditionalGuestAmounts',
            'Discount' => '\\dgsoft\\StructType\\DgDiscount',
            'AdditionalCharges' => '\\dgsoft\\StructType\\DgAdditionalCharges',
            'AdditionalCharge' => '\\dgsoft\\StructType\\DgAdditionalCharge',
            'TotalType' => '\\dgsoft\\StructType\\DgTotalType',
            'DiscountType' => '\\dgsoft\\StructType\\DgDiscountType',
            'AdditionalGuestAmountType' => '\\dgsoft\\StructType\\DgAdditionalGuestAmountType',
            'ArrayOfFeeType' => '\\dgsoft\\ArrayType\\DgArrayOfFeeType',
            'FeeType' => '\\dgsoft\\StructType\\DgFeeType',
            'ArrayOfRequiredPaymentsTypeGuaranteePayment' => '\\dgsoft\\ArrayType\\DgArrayOfRequiredPaymentsTypeGuaranteePayment',
            'GuaranteePayment' => '\\dgsoft\\StructType\\DgGuaranteePayment',
            'Address' => '\\dgsoft\\StructType\\DgAddress',
            'ArrayOfPaymentFormType' => '\\dgsoft\\ArrayType\\DgArrayOfPaymentFormType',
            'ArrayOfRoomRateTypeFeature' => '\\dgsoft\\ArrayType\\DgArrayOfRoomRateTypeFeature',
            'Feature' => '\\dgsoft\\StructType\\DgFeature',
            'ArrayOfRoomStayTypeRoomRatesRoomRateRestriction' => '\\dgsoft\\ArrayType\\DgArrayOfRoomStayTypeRoomRatesRoomRateRestriction',
            'DOW_RestrictionsType' => '\\dgsoft\\StructType\\DgDOW_RestrictionsType',
            'AvailableDaysOfWeek' => '\\dgsoft\\StructType\\DgAvailableDaysOfWeek',
            'ArrivalDaysOfWeek' => '\\dgsoft\\StructType\\DgArrivalDaysOfWeek',
            'DepartureDaysOfWeek' => '\\dgsoft\\StructType\\DgDepartureDaysOfWeek',
            'RequiredDaysOfWeek' => '\\dgsoft\\StructType\\DgRequiredDaysOfWeek',
            'GuestCountType' => '\\dgsoft\\StructType\\DgGuestCountType',
            'GuestCount' => '\\dgsoft\\StructType\\DgGuestCount',
            'DateTimeSpanType' => '\\dgsoft\\StructType\\DgDateTimeSpanType',
            'EndDateWindow' => '\\dgsoft\\StructType\\DgEndDateWindow',
            'StartDateWindow' => '\\dgsoft\\StructType\\DgStartDateWindow',
            'TimeInstantType' => '\\dgsoft\\StructType\\DgTimeInstantType',
            'BasicPropertyInfoType' => '\\dgsoft\\StructType\\DgBasicPropertyInfoType',
            'Award' => '\\dgsoft\\StructType\\DgAward',
            'HotelAmenity' => '\\dgsoft\\StructType\\DgHotelAmenity',
            'Recreation' => '\\dgsoft\\StructType\\DgRecreation',
            'Service' => '\\dgsoft\\StructType\\DgService',
            'ArrayOfString' => '\\dgsoft\\ArrayType\\DgArrayOfString',
            'ArrayOfBasicPropertyInfoTypeContactNumber' => '\\dgsoft\\ArrayType\\DgArrayOfBasicPropertyInfoTypeContactNumber',
            'ContactNumber' => '\\dgsoft\\StructType\\DgContactNumber',
            'RelativePositionType' => '\\dgsoft\\StructType\\DgRelativePositionType',
            'TransportationsType' => '\\dgsoft\\StructType\\DgTransportationsType',
            'ArrayOfTransportationTypeTransportation' => '\\dgsoft\\ArrayType\\DgArrayOfTransportationTypeTransportation',
            'Transportation' => '\\dgsoft\\StructType\\DgTransportation',
            'MultimediaDescriptionsType' => '\\dgsoft\\StructType\\DgMultimediaDescriptionsType',
            'MultimediaDescriptionType' => '\\dgsoft\\StructType\\DgMultimediaDescriptionType',
            'ArrayOfImageItemsTypeImageItem' => '\\dgsoft\\ArrayType\\DgArrayOfImageItemsTypeImageItem',
            'ImageItemsTypeImageItem' => '\\dgsoft\\StructType\\DgImageItemsTypeImageItem',
            'ImageDescriptionType' => '\\dgsoft\\StructType\\DgImageDescriptionType',
            'ImageFormat' => '\\dgsoft\\StructType\\DgImageFormat',
            'Description' => '\\dgsoft\\StructType\\DgDescription',
            'ImageItemType' => '\\dgsoft\\StructType\\DgImageItemType',
            'ArrayOfVideoItemsTypeVideoItem' => '\\dgsoft\\ArrayType\\DgArrayOfVideoItemsTypeVideoItem',
            'VideoItemsTypeVideoItem' => '\\dgsoft\\StructType\\DgVideoItemsTypeVideoItem',
            'VideoDescriptionType' => '\\dgsoft\\StructType\\DgVideoDescriptionType',
            'VideoFormat' => '\\dgsoft\\StructType\\DgVideoFormat',
            'VideoItemType' => '\\dgsoft\\StructType\\DgVideoItemType',
            'ArrayOfTextItemsTypeTextItem' => '\\dgsoft\\ArrayType\\DgArrayOfTextItemsTypeTextItem',
            'TextItemsTypeTextItem' => '\\dgsoft\\StructType\\DgTextItemsTypeTextItem',
            'TextDescriptionType' => '\\dgsoft\\StructType\\DgTextDescriptionType',
            'OperationSchedulesType' => '\\dgsoft\\StructType\\DgOperationSchedulesType',
            'OperationScheduleType' => '\\dgsoft\\StructType\\DgOperationScheduleType',
            'ArrayOfOperationScheduleTypeOperationTime' => '\\dgsoft\\ArrayType\\DgArrayOfOperationScheduleTypeOperationTime',
            'OperationTime' => '\\dgsoft\\StructType\\DgOperationTime',
            'PropertyValueMatchType' => '\\dgsoft\\StructType\\DgPropertyValueMatchType',
            'SearchValueMatch' => '\\dgsoft\\StructType\\DgSearchValueMatch',
            'RateRange' => '\\dgsoft\\StructType\\DgRateRange',
            'ArrayOfPropertyValueMatchTypeAmenity' => '\\dgsoft\\ArrayType\\DgArrayOfPropertyValueMatchTypeAmenity',
            'Amenity' => '\\dgsoft\\StructType\\DgAmenity',
            'ServiceFeesType' => '\\dgsoft\\StructType\\DgServiceFeesType',
            'ServiceFeeType' => '\\dgsoft\\StructType\\DgServiceFeeType',
            'PassengerTypeQuantityType' => '\\dgsoft\\StructType\\DgPassengerTypeQuantityType',
            'BookingFeeType' => '\\dgsoft\\StructType\\DgBookingFeeType',
            'OtherExtraCostType' => '\\dgsoft\\StructType\\DgOtherExtraCostType',
            'CCOBFeeType' => '\\dgsoft\\StructType\\DgCCOBFeeType',
            'AncillaryFeeType' => '\\dgsoft\\StructType\\DgAncillaryFeeType',
            'AirlineOBFeeType' => '\\dgsoft\\StructType\\DgAirlineOBFeeType',
            'PaymentFeeType' => '\\dgsoft\\StructType\\DgPaymentFeeType',
            'DeliveryFeeType' => '\\dgsoft\\StructType\\DgDeliveryFeeType',
            'InsuranceExtraFeeType' => '\\dgsoft\\StructType\\DgInsuranceExtraFeeType',
            'CarExtraFeeType' => '\\dgsoft\\StructType\\DgCarExtraFeeType',
            'HotelExtraFeeType' => '\\dgsoft\\StructType\\DgHotelExtraFeeType',
            'ArrayOfServiceRPHsTypeServiceRPH' => '\\dgsoft\\ArrayType\\DgArrayOfServiceRPHsTypeServiceRPH',
            'ServiceRPH' => '\\dgsoft\\StructType\\DgServiceRPH',
            'ArrayOfServicesTypeService' => '\\dgsoft\\ArrayType\\DgArrayOfServicesTypeService',
            'ResCommonDetailType' => '\\dgsoft\\StructType\\DgResCommonDetailType',
            'ArrayOfResGuestRPHsTypeResGuestRPH' => '\\dgsoft\\ArrayType\\DgArrayOfResGuestRPHsTypeResGuestRPH',
            'ResGuestRPH' => '\\dgsoft\\StructType\\DgResGuestRPH',
            'ArrayOfMembershipTypeMembership' => '\\dgsoft\\ArrayType\\DgArrayOfMembershipTypeMembership',
            'Membership' => '\\dgsoft\\StructType\\DgMembership',
            'ArrayOfSpecialRequestTypeSpecialRequest' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialRequestTypeSpecialRequest',
            'SpecialRequest' => '\\dgsoft\\StructType\\DgSpecialRequest',
            'ResGlobalInfoType' => '\\dgsoft\\StructType\\DgResGlobalInfoType',
            'ArrayOfHotelReservationIDsTypeHotelReservationID' => '\\dgsoft\\ArrayType\\DgArrayOfHotelReservationIDsTypeHotelReservationID',
            'HotelReservationID' => '\\dgsoft\\StructType\\DgHotelReservationID',
            'ArrayOfRoutingHopTypeRoutingHop' => '\\dgsoft\\ArrayType\\DgArrayOfRoutingHopTypeRoutingHop',
            'RoutingHop' => '\\dgsoft\\StructType\\DgRoutingHop',
            'ArrayOfProfilesTypeProfileInfo' => '\\dgsoft\\ArrayType\\DgArrayOfProfilesTypeProfileInfo',
            'ProfileInfo' => '\\dgsoft\\StructType\\DgProfileInfo',
            'ProfileType' => '\\dgsoft\\StructType\\DgProfileType',
            'AccessesType' => '\\dgsoft\\StructType\\DgAccessesType',
            'Access' => '\\dgsoft\\StructType\\DgAccess',
            'CustomerType' => '\\dgsoft\\StructType\\DgCustomerType',
            'Telephone' => '\\dgsoft\\StructType\\DgTelephone',
            'CitizenCountryName' => '\\dgsoft\\StructType\\DgCitizenCountryName',
            'URL_Type' => '\\dgsoft\\StructType\\DgURL_Type',
            'RelatedTravelerType' => '\\dgsoft\\StructType\\DgRelatedTravelerType',
            'ContactPersonType' => '\\dgsoft\\StructType\\DgContactPersonType',
            'EmployeeInfoType' => '\\dgsoft\\StructType\\DgEmployeeInfoType',
            'DocumentType' => '\\dgsoft\\StructType\\DgDocumentType',
            'ArrayOfString1' => '\\dgsoft\\ArrayType\\DgArrayOfString1',
            'CustomerPrimaryAdditionalTypeAdditional' => '\\dgsoft\\StructType\\DgCustomerPrimaryAdditionalTypeAdditional',
            'CustomerPrimaryAdditionalTypePrimary' => '\\dgsoft\\StructType\\DgCustomerPrimaryAdditionalTypePrimary',
            'PreferencesType' => '\\dgsoft\\StructType\\DgPreferencesType',
            'PrefCollection' => '\\dgsoft\\StructType\\DgPrefCollection',
            'CommonPrefType' => '\\dgsoft\\StructType\\DgCommonPrefType',
            'NamePrefType' => '\\dgsoft\\StructType\\DgNamePrefType',
            'PhonePrefType' => '\\dgsoft\\StructType\\DgPhonePrefType',
            'AddressPrefType' => '\\dgsoft\\StructType\\DgAddressPrefType',
            'PaymentFormPrefType' => '\\dgsoft\\StructType\\DgPaymentFormPrefType',
            'InterestPrefType' => '\\dgsoft\\StructType\\DgInterestPrefType',
            'InsurancePrefType' => '\\dgsoft\\StructType\\DgInsurancePrefType',
            'SeatingPrefType' => '\\dgsoft\\StructType\\DgSeatingPrefType',
            'TicketDistribPrefType' => '\\dgsoft\\StructType\\DgTicketDistribPrefType',
            'MediaEntertainPrefType' => '\\dgsoft\\StructType\\DgMediaEntertainPrefType',
            'PetInfoPrefType' => '\\dgsoft\\StructType\\DgPetInfoPrefType',
            'MealPrefType' => '\\dgsoft\\StructType\\DgMealPrefType',
            'LoyaltyPrefType' => '\\dgsoft\\StructType\\DgLoyaltyPrefType',
            'SpecRequestPrefType' => '\\dgsoft\\StructType\\DgSpecRequestPrefType',
            'RelatedTravelerPrefType' => '\\dgsoft\\StructType\\DgRelatedTravelerPrefType',
            'VehicleProfileRentalPrefType' => '\\dgsoft\\StructType\\DgVehicleProfileRentalPrefType',
            'LoyaltyPref' => '\\dgsoft\\StructType\\DgLoyaltyPref',
            'PaymentFormPref' => '\\dgsoft\\StructType\\DgPaymentFormPref',
            'CoveragePref' => '\\dgsoft\\StructType\\DgCoveragePref',
            'SpecialEquipPref' => '\\dgsoft\\StructType\\DgSpecialEquipPref',
            'VehicleSpecialReqPrefType' => '\\dgsoft\\StructType\\DgVehicleSpecialReqPrefType',
            'VehiclePrefType' => '\\dgsoft\\StructType\\DgVehiclePrefType',
            'VehicleCoreType' => '\\dgsoft\\StructType\\DgVehicleCoreType',
            'VehType' => '\\dgsoft\\StructType\\DgVehType',
            'VehicleType' => '\\dgsoft\\StructType\\DgVehicleType',
            'VehicleTypeVehMakeModel' => '\\dgsoft\\StructType\\DgVehicleTypeVehMakeModel',
            'VehicleTypeVehIdentity' => '\\dgsoft\\StructType\\DgVehicleTypeVehIdentity',
            'AirlinePrefType' => '\\dgsoft\\StructType\\DgAirlinePrefType',
            'FareRestrictPref' => '\\dgsoft\\StructType\\DgFareRestrictPref',
            'FlightTypePref' => '\\dgsoft\\StructType\\DgFlightTypePref',
            'CabinPref' => '\\dgsoft\\StructType\\DgCabinPref',
            'SeatPref' => '\\dgsoft\\StructType\\DgSeatPref',
            'SSR_Pref' => '\\dgsoft\\StructType\\DgSSR_Pref',
            'EquipmentTypePref' => '\\dgsoft\\StructType\\DgEquipmentTypePref',
            'EquipmentType' => '\\dgsoft\\StructType\\DgEquipmentType',
            'HotelPrefType' => '\\dgsoft\\StructType\\DgHotelPrefType',
            'PropertyNamePrefType' => '\\dgsoft\\StructType\\DgPropertyNamePrefType',
            'PropertyLocationPrefType' => '\\dgsoft\\StructType\\DgPropertyLocationPrefType',
            'PropertyTypePrefType' => '\\dgsoft\\StructType\\DgPropertyTypePrefType',
            'PropertyClassPrefType' => '\\dgsoft\\StructType\\DgPropertyClassPrefType',
            'PropertyAmenityPrefType' => '\\dgsoft\\StructType\\DgPropertyAmenityPrefType',
            'RoomLocationPrefType' => '\\dgsoft\\StructType\\DgRoomLocationPrefType',
            'BedTypePrefType' => '\\dgsoft\\StructType\\DgBedTypePrefType',
            'FoodSrvcPrefType' => '\\dgsoft\\StructType\\DgFoodSrvcPrefType',
            'RecreationSrvcPrefType' => '\\dgsoft\\StructType\\DgRecreationSrvcPrefType',
            'BusinessSrvcPrefType' => '\\dgsoft\\StructType\\DgBusinessSrvcPrefType',
            'PersonalSrvcPrefType' => '\\dgsoft\\StructType\\DgPersonalSrvcPrefType',
            'SecurityFeaturePrefType' => '\\dgsoft\\StructType\\DgSecurityFeaturePrefType',
            'PhysChallFeaturePrefType' => '\\dgsoft\\StructType\\DgPhysChallFeaturePrefType',
            'OtherSrvcPrefType' => '\\dgsoft\\StructType\\DgOtherSrvcPrefType',
            'CompanyInfoType' => '\\dgsoft\\StructType\\DgCompanyInfoType',
            'LoyaltyProgramType' => '\\dgsoft\\StructType\\DgLoyaltyProgramType',
            'AffiliationsType' => '\\dgsoft\\StructType\\DgAffiliationsType',
            'OrganizationType' => '\\dgsoft\\StructType\\DgOrganizationType',
            'OrgMemberName' => '\\dgsoft\\StructType\\DgOrgMemberName',
            'EmployerType' => '\\dgsoft\\StructType\\DgEmployerType',
            'TravelClubType' => '\\dgsoft\\StructType\\DgTravelClubType',
            'ClubMemberName' => '\\dgsoft\\StructType\\DgClubMemberName',
            'InsuranceType' => '\\dgsoft\\StructType\\DgInsuranceType',
            'AgreementsType' => '\\dgsoft\\StructType\\DgAgreementsType',
            'CertificationType' => '\\dgsoft\\StructType\\DgCertificationType',
            'AllianceConsortiumType' => '\\dgsoft\\StructType\\DgAllianceConsortiumType',
            'AllianceMember' => '\\dgsoft\\StructType\\DgAllianceMember',
            'CommissionInfoType' => '\\dgsoft\\StructType\\DgCommissionInfoType',
            'ArrayOfBookingRulesTypeBookingRule' => '\\dgsoft\\ArrayType\\DgArrayOfBookingRulesTypeBookingRule',
            'BookingRule' => '\\dgsoft\\StructType\\DgBookingRule',
            'CheckoutCharge' => '\\dgsoft\\StructType\\DgCheckoutCharge',
            'ArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee' => '\\dgsoft\\ArrayType\\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee',
            'AcceptableGuarantee' => '\\dgsoft\\StructType\\DgAcceptableGuarantee',
            'LengthsOfStayType' => '\\dgsoft\\StructType\\DgLengthsOfStayType',
            'LengthOfStay' => '\\dgsoft\\StructType\\DgLengthOfStay',
            'LOS_Pattern' => '\\dgsoft\\StructType\\DgLOS_Pattern',
            'ArrayOfViewershipsTypeViewership' => '\\dgsoft\\ArrayType\\DgArrayOfViewershipsTypeViewership',
            'Viewership' => '\\dgsoft\\StructType\\DgViewership',
            'ViewershipCodes' => '\\dgsoft\\StructType\\DgViewershipCodes',
            'SystemCodes' => '\\dgsoft\\StructType\\DgSystemCodes',
            'SystemCode' => '\\dgsoft\\StructType\\DgSystemCode',
            'LocationCodes' => '\\dgsoft\\StructType\\DgLocationCodes',
            'LocationCode' => '\\dgsoft\\StructType\\DgLocationCode',
            'BookingChannelCodes' => '\\dgsoft\\StructType\\DgBookingChannelCodes',
            'BookingChannelCode' => '\\dgsoft\\StructType\\DgBookingChannelCode',
            'ArrayOfViewershipsTypeViewershipProfileType' => '\\dgsoft\\ArrayType\\DgArrayOfViewershipsTypeViewershipProfileType',
            'ArrayOfUniqueID_Type' => '\\dgsoft\\ArrayType\\DgArrayOfUniqueID_Type',
            'ArrayOfProfileType' => '\\dgsoft\\ArrayType\\DgArrayOfProfileType',
            'ArrayOfViewershipsTypeViewershipDistributorType' => '\\dgsoft\\ArrayType\\DgArrayOfViewershipsTypeViewershipDistributorType',
            'DistributorType' => '\\dgsoft\\StructType\\DgDistributorType',
            'ArrayOfBookingRulesTypeBookingRuleAdditionalRule' => '\\dgsoft\\ArrayType\\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule',
            'ArrayOfResGuestsTypeResGuest' => '\\dgsoft\\ArrayType\\DgArrayOfResGuestsTypeResGuest',
            'ResGuest' => '\\dgsoft\\StructType\\DgResGuest',
            'ArrayOfResGuestsTypeResGuestProfileRPH' => '\\dgsoft\\ArrayType\\DgArrayOfResGuestsTypeResGuestProfileRPH',
            'ProfileRPH' => '\\dgsoft\\StructType\\DgProfileRPH',
            'TransportInfoType' => '\\dgsoft\\StructType\\DgTransportInfoType',
            'TransportInfo' => '\\dgsoft\\StructType\\DgTransportInfo',
            'WrittenConfInstType' => '\\dgsoft\\StructType\\DgWrittenConfInstType',
            'ArrayOfWarningType' => '\\dgsoft\\ArrayType\\DgArrayOfWarningType',
            'AirItineraryPricingInfoType' => '\\dgsoft\\StructType\\DgAirItineraryPricingInfoType',
            'FareType' => '\\dgsoft\\StructType\\DgFareType',
            'BaseFare' => '\\dgsoft\\StructType\\DgBaseFare',
            'MarkupFare' => '\\dgsoft\\StructType\\DgMarkupFare',
            'EquivFare' => '\\dgsoft\\StructType\\DgEquivFare',
            'TotalFare' => '\\dgsoft\\StructType\\DgTotalFare',
            'TotalAmountInTicketingCurrency' => '\\dgsoft\\StructType\\DgTotalAmountInTicketingCurrency',
            'FareConstruction' => '\\dgsoft\\StructType\\DgFareConstruction',
            'UnstructuredFareCalc' => '\\dgsoft\\StructType\\DgUnstructuredFareCalc',
            'ArrayOfAirTaxType' => '\\dgsoft\\ArrayType\\DgArrayOfAirTaxType',
            'AirTaxType' => '\\dgsoft\\StructType\\DgAirTaxType',
            'ArrayOfAirFeeType' => '\\dgsoft\\ArrayType\\DgArrayOfAirFeeType',
            'AirFeeType' => '\\dgsoft\\StructType\\DgAirFeeType',
            'ArrayOfPTCFareBreakdownType' => '\\dgsoft\\ArrayType\\DgArrayOfPTCFareBreakdownType',
            'PTCFareBreakdownType' => '\\dgsoft\\StructType\\DgPTCFareBreakdownType',
            'TravelerRefNumber' => '\\dgsoft\\StructType\\DgTravelerRefNumber',
            'Endorsements' => '\\dgsoft\\StructType\\DgEndorsements',
            'Endorsement' => '\\dgsoft\\StructType\\DgEndorsement',
            'FareInfo' => '\\dgsoft\\StructType\\DgFareInfo',
            'PricingUnit' => '\\dgsoft\\StructType\\DgPricingUnit',
            'FareComponent' => '\\dgsoft\\StructType\\DgFareComponent',
            'FlightLeg' => '\\dgsoft\\StructType\\DgFlightLeg',
            'ArrayOfString2' => '\\dgsoft\\ArrayType\\DgArrayOfString2',
            'ArrayOfPTCFareBreakdownTypeTicketDesignator' => '\\dgsoft\\ArrayType\\DgArrayOfPTCFareBreakdownTypeTicketDesignator',
            'TicketDesignator' => '\\dgsoft\\StructType\\DgTicketDesignator',
            'FareInfoType' => '\\dgsoft\\StructType\\DgFareInfoType',
            'FareReference' => '\\dgsoft\\StructType\\DgFareReference',
            'RuleInfo' => '\\dgsoft\\StructType\\DgRuleInfo',
            'Date' => '\\dgsoft\\StructType\\DgDate',
            'Fare' => '\\dgsoft\\StructType\\DgFare',
            'PTC' => '\\dgsoft\\StructType\\DgPTC',
            'DiscountPricing' => '\\dgsoft\\StructType\\DgDiscountPricing',
            'City' => '\\dgsoft\\StructType\\DgCity',
            'Airport' => '\\dgsoft\\StructType\\DgAirport',
            'RuleInfoType' => '\\dgsoft\\StructType\\DgRuleInfoType',
            'ResTicketingRules' => '\\dgsoft\\StructType\\DgResTicketingRules',
            'AdvResTicketing' => '\\dgsoft\\StructType\\DgAdvResTicketing',
            'ChargesRules' => '\\dgsoft\\StructType\\DgChargesRules',
            'AdvResTicketingType' => '\\dgsoft\\StructType\\DgAdvResTicketingType',
            'AdvReservation' => '\\dgsoft\\StructType\\DgAdvReservation',
            'AdvTicketing' => '\\dgsoft\\StructType\\DgAdvTicketing',
            'StayRestrictionsType' => '\\dgsoft\\StructType\\DgStayRestrictionsType',
            'MinimumStay' => '\\dgsoft\\StructType\\DgMinimumStay',
            'MaximumStay' => '\\dgsoft\\StructType\\DgMaximumStay',
            'VoluntaryChangesType' => '\\dgsoft\\StructType\\DgVoluntaryChangesType',
            'Penalty' => '\\dgsoft\\StructType\\DgPenalty',
            'FareRuleResponseInfoTypeFareRuleInfo' => '\\dgsoft\\StructType\\DgFareRuleResponseInfoTypeFareRuleInfo',
            'FormattedTextType' => '\\dgsoft\\StructType\\DgFormattedTextType',
            'FormattedTextSubSectionType' => '\\dgsoft\\StructType\\DgFormattedTextSubSectionType',
            'VehicleLocationAdditionalDetailsTypeShuttleShuttleInfo' => '\\dgsoft\\StructType\\DgVehicleLocationAdditionalDetailsTypeShuttleShuttleInfo',
            'VehicleLocationInformationType' => '\\dgsoft\\StructType\\DgVehicleLocationInformationType',
            'BookFlightSegmentType' => '\\dgsoft\\StructType\\DgBookFlightSegmentType',
            'FlightCharacteristic' => '\\dgsoft\\StructType\\DgFlightCharacteristic',
            'StopLocation' => '\\dgsoft\\StructType\\DgStopLocation',
            'FlightSegmentType' => '\\dgsoft\\StructType\\DgFlightSegmentType',
            'MarketingAirline' => '\\dgsoft\\StructType\\DgMarketingAirline',
            'FlightSegmentBaseType' => '\\dgsoft\\StructType\\DgFlightSegmentBaseType',
            'DepartureAirport' => '\\dgsoft\\StructType\\DgDepartureAirport',
            'ArrivalAirport' => '\\dgsoft\\StructType\\DgArrivalAirport',
            'ArrayOfFreeBaggageSegmentItem' => '\\dgsoft\\ArrayType\\DgArrayOfFreeBaggageSegmentItem',
            'Baggage' => '\\dgsoft\\StructType\\DgBaggage',
            'ArrayOfBookFlightSegmentTypeBookingClassAvail' => '\\dgsoft\\ArrayType\\DgArrayOfBookFlightSegmentTypeBookingClassAvail',
            'BookingClassAvail' => '\\dgsoft\\StructType\\DgBookingClassAvail',
            'ArrayOfInFlightService' => '\\dgsoft\\ArrayType\\DgArrayOfInFlightService',
            'inFlightSrv' => '\\dgsoft\\StructType\\DgInFlightSrv',
            'ArrayOfAirItineraryPricingInfoTypeFareInfo' => '\\dgsoft\\ArrayType\\DgArrayOfAirItineraryPricingInfoTypeFareInfo',
            'BookingPriceInfoType' => '\\dgsoft\\StructType\\DgBookingPriceInfoType',
            'PriceRequestInformationType' => '\\dgsoft\\StructType\\DgPriceRequestInformationType',
            'NegotiatedFareCode' => '\\dgsoft\\StructType\\DgNegotiatedFareCode',
            'RebookOption' => '\\dgsoft\\StructType\\DgRebookOption',
            'FailbackRS' => '\\dgsoft\\StructType\\DgFailbackRS',
            'FlightSegment' => '\\dgsoft\\StructType\\DgFlightSegment',
            'FreeBaggageAllowancesTypes' => '\\dgsoft\\StructType\\DgFreeBaggageAllowancesTypes',
            'ArrayOfFreeBaggageAllowanceTypes' => '\\dgsoft\\ArrayType\\DgArrayOfFreeBaggageAllowanceTypes',
            'FreeBaggageAllowanceTypes' => '\\dgsoft\\StructType\\DgFreeBaggageAllowanceTypes',
            'FailbackIndicator' => '\\dgsoft\\StructType\\DgFailbackIndicator',
            'FailbackParameter' => '\\dgsoft\\StructType\\DgFailbackParameter',
            'ScheduleChangeParameter' => '\\dgsoft\\StructType\\DgScheduleChangeParameter',
            'SeatTakenParameter' => '\\dgsoft\\StructType\\DgSeatTakenParameter',
            'FarebasisChangesParameter' => '\\dgsoft\\StructType\\DgFarebasisChangesParameter',
            'AncillaryChangeParameter' => '\\dgsoft\\StructType\\DgAncillaryChangeParameter',
            'FailbackFlightRules' => '\\dgsoft\\StructType\\DgFailbackFlightRules',
            'PriceMessageInfoType' => '\\dgsoft\\StructType\\DgPriceMessageInfoType',
            'ArrayOfMiniRulesPriceMessages' => '\\dgsoft\\ArrayType\\DgArrayOfMiniRulesPriceMessages',
            'MiniRulesPriceMessages' => '\\dgsoft\\StructType\\DgMiniRulesPriceMessages',
            'ArrayOfMiniRulesPriceText' => '\\dgsoft\\ArrayType\\DgArrayOfMiniRulesPriceText',
            'MiniRulesPriceText' => '\\dgsoft\\StructType\\DgMiniRulesPriceText',
            'AirReservationType' => '\\dgsoft\\StructType\\DgAirReservationType',
            'Fulfillment' => '\\dgsoft\\StructType\\DgFulfillment',
            'PricingOverview' => '\\dgsoft\\StructType\\DgPricingOverview',
            'PricingIndicator' => '\\dgsoft\\StructType\\DgPricingIndicator',
            'Account' => '\\dgsoft\\StructType\\DgAccount',
            'ArrayOfOSIelement' => '\\dgsoft\\ArrayType\\DgArrayOfOSIelement',
            'OSIelement' => '\\dgsoft\\StructType\\DgOSIelement',
            'AirItineraryType' => '\\dgsoft\\StructType\\DgAirItineraryType',
            'ArrayOfAirItineraryTypeOriginDestinationOption' => '\\dgsoft\\ArrayType\\DgArrayOfAirItineraryTypeOriginDestinationOption',
            'OriginDestinationOption' => '\\dgsoft\\StructType\\DgOriginDestinationOption',
            'OriginDestinationOptionType' => '\\dgsoft\\StructType\\DgOriginDestinationOptionType',
            'ArrayOfOriginDestinationCombinationType' => '\\dgsoft\\ArrayType\\DgArrayOfOriginDestinationCombinationType',
            'OriginDestinationCombinationType' => '\\dgsoft\\StructType\\DgOriginDestinationCombinationType',
            'TravelerInfoType' => '\\dgsoft\\StructType\\DgTravelerInfoType',
            'AirTraveler' => '\\dgsoft\\StructType\\DgAirTraveler',
            'ETicketURLs' => '\\dgsoft\\StructType\\DgETicketURLs',
            'AirTravelerType' => '\\dgsoft\\StructType\\DgAirTravelerType',
            'LCCParameters' => '\\dgsoft\\StructType\\DgLCCParameters',
            'ProfileRef' => '\\dgsoft\\StructType\\DgProfileRef',
            'Email' => '\\dgsoft\\StructType\\DgEmail',
            'Document' => '\\dgsoft\\StructType\\DgDocument',
            'ArrayOfString3' => '\\dgsoft\\ArrayType\\DgArrayOfString3',
            'ETicketInfo' => '\\dgsoft\\StructType\\DgETicketInfo',
            'ArrayOfTaxInfo' => '\\dgsoft\\ArrayType\\DgArrayOfTaxInfo',
            'TaxInfo' => '\\dgsoft\\StructType\\DgTaxInfo',
            'ArrayOfETicketItineraryInfo' => '\\dgsoft\\ArrayType\\DgArrayOfETicketItineraryInfo',
            'ETicketItineraryInfo' => '\\dgsoft\\StructType\\DgETicketItineraryInfo',
            'ArrayOfETicketInfo' => '\\dgsoft\\ArrayType\\DgArrayOfETicketInfo',
            'AncillaryProductsType' => '\\dgsoft\\StructType\\DgAncillaryProductsType',
            'AncillaryProductType' => '\\dgsoft\\StructType\\DgAncillaryProductType',
            'AncillaryProductTypeBase' => '\\dgsoft\\StructType\\DgAncillaryProductTypeBase',
            'AncillaryEticketInfoType' => '\\dgsoft\\StructType\\DgAncillaryEticketInfoType',
            'AncillaryTicketRemarkType' => '\\dgsoft\\StructType\\DgAncillaryTicketRemarkType',
            'AncillaryTicketCouponType' => '\\dgsoft\\StructType\\DgAncillaryTicketCouponType',
            'AncillaryTicketCouponDetailType' => '\\dgsoft\\StructType\\DgAncillaryTicketCouponDetailType',
            'AncillaryTicketFareInfoType' => '\\dgsoft\\StructType\\DgAncillaryTicketFareInfoType',
            'AncillaryTicketFOPType' => '\\dgsoft\\StructType\\DgAncillaryTicketFOPType',
            'StandardAncillaryProductsType' => '\\dgsoft\\StructType\\DgStandardAncillaryProductsType',
            'SpecialReqDetailsType' => '\\dgsoft\\StructType\\DgSpecialReqDetailsType',
            'ArrayOfSpecialReqDetailsTypeSeatRequest' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialReqDetailsTypeSeatRequest',
            'SeatRequest' => '\\dgsoft\\StructType\\DgSeatRequest',
            'SeatRequestType' => '\\dgsoft\\StructType\\DgSeatRequestType',
            'ArrayOfSpecialReqDetailsTypeSpecialServiceRequest' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialReqDetailsTypeSpecialServiceRequest',
            'SpecialServiceRequest' => '\\dgsoft\\StructType\\DgSpecialServiceRequest',
            'SpecialServiceRequestType' => '\\dgsoft\\StructType\\DgSpecialServiceRequestType',
            'FlightLegType' => '\\dgsoft\\StructType\\DgFlightLegType',
            'ArrayOfSSRRequiredParameterRQ' => '\\dgsoft\\ArrayType\\DgArrayOfSSRRequiredParameterRQ',
            'SSRRequiredParameterRQ' => '\\dgsoft\\StructType\\DgSSRRequiredParameterRQ',
            'ArrayOfSpecialReqDetailsTypeOtherServiceInformation' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialReqDetailsTypeOtherServiceInformation',
            'OtherServiceInformation' => '\\dgsoft\\StructType\\DgOtherServiceInformation',
            'OtherServiceInfoType' => '\\dgsoft\\StructType\\DgOtherServiceInfoType',
            'ArrayOfSpecialReqDetailsTypeRemark' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialReqDetailsTypeRemark',
            'Remark' => '\\dgsoft\\StructType\\DgRemark',
            'ArrayOfSpecialReqDetailsTypeSpecialRemark' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialReqDetailsTypeSpecialRemark',
            'SpecialRemark' => '\\dgsoft\\StructType\\DgSpecialRemark',
            'SpecialRemarkType' => '\\dgsoft\\StructType\\DgSpecialRemarkType',
            'FlightRefNumber' => '\\dgsoft\\StructType\\DgFlightRefNumber',
            'ArrayOfSpecialRemarkTypeAuthorizedViewer' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialRemarkTypeAuthorizedViewer',
            'AuthorizedViewer' => '\\dgsoft\\StructType\\DgAuthorizedViewer',
            'ArrayOfPaymentDetailType' => '\\dgsoft\\ArrayType\\DgArrayOfPaymentDetailType',
            'GroupInfoType' => '\\dgsoft\\StructType\\DgGroupInfoType',
            'ArrayOfGroupDetailType' => '\\dgsoft\\ArrayType\\DgArrayOfGroupDetailType',
            'GroupDetailType' => '\\dgsoft\\StructType\\DgGroupDetailType',
            'TicketingInfoType' => '\\dgsoft\\StructType\\DgTicketingInfoType',
            'TicketingInfoRS_Type' => '\\dgsoft\\StructType\\DgTicketingInfoRS_Type',
            'ArrayOfAirReservationTypeQueue' => '\\dgsoft\\ArrayType\\DgArrayOfAirReservationTypeQueue',
            'FareRuleResponseInfoType' => '\\dgsoft\\StructType\\DgFareRuleResponseInfoType',
            'FareRuleResponseInfoTypeRouting' => '\\dgsoft\\StructType\\DgFareRuleResponseInfoTypeRouting',
            'FareRuleResponseInfoTypeRoutingInfo' => '\\dgsoft\\StructType\\DgFareRuleResponseInfoTypeRoutingInfo',
            'FareRuleResponseInfoTypeAdvisoryInfo' => '\\dgsoft\\StructType\\DgFareRuleResponseInfoTypeAdvisoryInfo',
            'MiniRuleResponseInfoType' => '\\dgsoft\\StructType\\DgMiniRuleResponseInfoType',
            'MiniRules' => '\\dgsoft\\StructType\\DgMiniRules',
            'ArrayOfFlightTermsAndCondition' => '\\dgsoft\\ArrayType\\DgArrayOfFlightTermsAndCondition',
            'FlightTermsAndCondition' => '\\dgsoft\\StructType\\DgFlightTermsAndCondition',
            'ArrayOfRuleInfos' => '\\dgsoft\\ArrayType\\DgArrayOfRuleInfos',
            'RuleInfos' => '\\dgsoft\\StructType\\DgRuleInfos',
            'RuleInfosDetails' => '\\dgsoft\\StructType\\DgRuleInfosDetails',
            'ArrayOfPNRRemarkInfo' => '\\dgsoft\\ArrayType\\DgArrayOfPNRRemarkInfo',
            'PNRRemarkInfo' => '\\dgsoft\\StructType\\DgPNRRemarkInfo',
            'BookingToBeCancelled' => '\\dgsoft\\StructType\\DgBookingToBeCancelled',
            'OTA_VehResRS' => '\\dgsoft\\StructType\\DgOTA_VehResRS',
            'OTA_VehResRSVehResRSCore' => '\\dgsoft\\StructType\\DgOTA_VehResRSVehResRSCore',
            'VehicleResRSCoreType' => '\\dgsoft\\StructType\\DgVehicleResRSCoreType',
            'VehicleReservationType' => '\\dgsoft\\StructType\\DgVehicleReservationType',
            'CustomerPrimaryAdditionalType' => '\\dgsoft\\StructType\\DgCustomerPrimaryAdditionalType',
            'VehicleReservationTypeVehSegmentCore' => '\\dgsoft\\StructType\\DgVehicleReservationTypeVehSegmentCore',
            'VehicleSegmentCoreType' => '\\dgsoft\\StructType\\DgVehicleSegmentCoreType',
            'VehicleRentalCoreType' => '\\dgsoft\\StructType\\DgVehicleRentalCoreType',
            'VehicleRentalRateType' => '\\dgsoft\\StructType\\DgVehicleRentalRateType',
            'ArrayOfVehicleChargeTypeTaxAmount' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleChargeTypeTaxAmount',
            'VehicleChargeTypeTaxAmount' => '\\dgsoft\\StructType\\DgVehicleChargeTypeTaxAmount',
            'ArrayOfVehicleVendorAddressType' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleVendorAddressType',
            'ArrayOfSpecialRemarkType' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialRemarkType',
            'VehicleRentalRateTypeRateDistance' => '\\dgsoft\\StructType\\DgVehicleRentalRateTypeRateDistance',
            'ArrayOfVehicleChargePurposeType' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleChargePurposeType',
            'VehicleChargePurposeType' => '\\dgsoft\\StructType\\DgVehicleChargePurposeType',
            'VehicleChargeType' => '\\dgsoft\\StructType\\DgVehicleChargeType',
            'ArrayOfVehicleChargeTypeTaxAmount1' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleChargeTypeTaxAmount1',
            'VehicleChargeTypeMinMax' => '\\dgsoft\\StructType\\DgVehicleChargeTypeMinMax',
            'VehicleChargeTypeCalculation' => '\\dgsoft\\StructType\\DgVehicleChargeTypeCalculation',
            'RateQualifierType' => '\\dgsoft\\StructType\\DgRateQualifierType',
            'ArrayOfRateQualifierTypeRateComment' => '\\dgsoft\\ArrayType\\DgArrayOfRateQualifierTypeRateComment',
            'VehicleRentalRateTypeRateRestrictions' => '\\dgsoft\\StructType\\DgVehicleRentalRateTypeRateRestrictions',
            'VehicleRentalRateTypeRateGuarantee' => '\\dgsoft\\StructType\\DgVehicleRentalRateTypeRateGuarantee',
            'VehicleRentalRateTypePickupReturnRule' => '\\dgsoft\\StructType\\DgVehicleRentalRateTypePickupReturnRule',
            'ArrayOfVehicleEquipmentPricedType' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleEquipmentPricedType',
            'VehicleEquipmentPricedType' => '\\dgsoft\\StructType\\DgVehicleEquipmentPricedType',
            'VehicleEquipmentType' => '\\dgsoft\\StructType\\DgVehicleEquipmentType',
            'ArrayOfVehicleChargePurposeType1' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleChargePurposeType1',
            'VehicleSegmentCoreTypeTotalCharge' => '\\dgsoft\\StructType\\DgVehicleSegmentCoreTypeTotalCharge',
            'VehicleSegmentAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleSegmentAdditionalInfoType',
            'ArrayOfMonetaryRuleType' => '\\dgsoft\\ArrayType\\DgArrayOfMonetaryRuleType',
            'MonetaryRuleType' => '\\dgsoft\\StructType\\DgMonetaryRuleType',
            'ArrayOfCoveragePricedType' => '\\dgsoft\\ArrayType\\DgArrayOfCoveragePricedType',
            'CoveragePricedType' => '\\dgsoft\\StructType\\DgCoveragePricedType',
            'CoverageType' => '\\dgsoft\\StructType\\DgCoverageType',
            'OffLocationServicePricedType' => '\\dgsoft\\StructType\\DgOffLocationServicePricedType',
            'OffLocationServiceType' => '\\dgsoft\\StructType\\DgOffLocationServiceType',
            'OffLocationServiceCoreType' => '\\dgsoft\\StructType\\DgOffLocationServiceCoreType',
            'OffLocationServiceTypeTelephone' => '\\dgsoft\\StructType\\DgOffLocationServiceTypeTelephone',
            'ArrayOfFormattedTextType' => '\\dgsoft\\ArrayType\\DgArrayOfFormattedTextType',
            'VehicleLocationDetailsType' => '\\dgsoft\\StructType\\DgVehicleLocationDetailsType',
            'LocationOpeningHour' => '\\dgsoft\\StructType\\DgLocationOpeningHour',
            'VehicleLocationDetailsTypeTelephone' => '\\dgsoft\\StructType\\DgVehicleLocationDetailsTypeTelephone',
            'VehicleLocationAdditionalDetailsType' => '\\dgsoft\\StructType\\DgVehicleLocationAdditionalDetailsType',
            'ArrayOfVehicleLocationInformationType' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleLocationInformationType',
            'VehicleWhereAtFacilityType' => '\\dgsoft\\StructType\\DgVehicleWhereAtFacilityType',
            'VehicleLocationAdditionalDetailsTypeShuttle' => '\\dgsoft\\StructType\\DgVehicleLocationAdditionalDetailsTypeShuttle',
            'ArrayOfVehicleLocationAdditionalDetailsTypeShuttleShuttleInfo' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleLocationAdditionalDetailsTypeShuttleShuttleInfo',
            'ArrayOfVehicleLocationAdditionalDetailsTypeOneWayDropLocation' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleLocationAdditionalDetailsTypeOneWayDropLocation',
            'VehicleTourInfoType' => '\\dgsoft\\StructType\\DgVehicleTourInfoType',
            'VehicleResRSAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleResRSAdditionalInfoType',
            'QueueRQ' => '\\dgsoft\\StructType\\DgQueueRQ',
            'QueueResponse' => '\\dgsoft\\StructType\\DgQueueResponse',
            'QueueRS' => '\\dgsoft\\StructType\\DgQueueRS',
            'PNRListType' => '\\dgsoft\\StructType\\DgPNRListType',
            'PNRListItemType' => '\\dgsoft\\StructType\\DgPNRListItemType',
            'AddPNRToQueue' => '\\dgsoft\\StructType\\DgAddPNRToQueue',
            'AddPNRToQueueResponse' => '\\dgsoft\\StructType\\DgAddPNRToQueueResponse',
            'SearchFlight' => '\\dgsoft\\StructType\\DgSearchFlight',
            'OTA_AirLowFareSearchRQ' => '\\dgsoft\\StructType\\DgOTA_AirLowFareSearchRQ',
            'ProcessingInfo' => '\\dgsoft\\StructType\\DgProcessingInfo',
            'OriginDestinationInformation' => '\\dgsoft\\StructType\\DgOriginDestinationInformation',
            'AlternateLocationInfo' => '\\dgsoft\\StructType\\DgAlternateLocationInfo',
            'TravelPreferences' => '\\dgsoft\\StructType\\DgTravelPreferences',
            'TravelerInfoSummary' => '\\dgsoft\\StructType\\DgTravelerInfoSummary',
            'AdvanceSearchInfo' => '\\dgsoft\\StructType\\DgAdvanceSearchInfo',
            'MaxLayoverPerConnection' => '\\dgsoft\\StructType\\DgMaxLayoverPerConnection',
            'OriginDestinationInformationType' => '\\dgsoft\\StructType\\DgOriginDestinationInformationType',
            'OriginLocation' => '\\dgsoft\\StructType\\DgOriginLocation',
            'DestinationLocation' => '\\dgsoft\\StructType\\DgDestinationLocation',
            'TravelDateTimeType' => '\\dgsoft\\StructType\\DgTravelDateTimeType',
            'ArrayOfOriginDestinationInformationTypeOriginLocation' => '\\dgsoft\\ArrayType\\DgArrayOfOriginDestinationInformationTypeOriginLocation',
            'ArrayOfOriginDestinationInformationTypeDestinationLocation' => '\\dgsoft\\ArrayType\\DgArrayOfOriginDestinationInformationTypeDestinationLocation',
            'ArrayOfConnectionTypeConnectionLocation' => '\\dgsoft\\ArrayType\\DgArrayOfConnectionTypeConnectionLocation',
            'ConnectionLocation' => '\\dgsoft\\StructType\\DgConnectionLocation',
            'RadiusItem' => '\\dgsoft\\StructType\\DgRadiusItem',
            'SpecificFlightInfoType' => '\\dgsoft\\StructType\\DgSpecificFlightInfoType',
            'BookingClassPref' => '\\dgsoft\\StructType\\DgBookingClassPref',
            'AirSearchPrefsType' => '\\dgsoft\\StructType\\DgAirSearchPrefsType',
            'VendorPref' => '\\dgsoft\\StructType\\DgVendorPref',
            'TicketDistribPref' => '\\dgsoft\\StructType\\DgTicketDistribPref',
            'TravelerInfoSummaryType' => '\\dgsoft\\StructType\\DgTravelerInfoSummaryType',
            'TravelerInformationType' => '\\dgsoft\\StructType\\DgTravelerInformationType',
            'AirlineDiversityType' => '\\dgsoft\\StructType\\DgAirlineDiversityType',
            'ExpandedParametersType' => '\\dgsoft\\StructType\\DgExpandedParametersType',
            'SearchFlightResponse' => '\\dgsoft\\StructType\\DgSearchFlightResponse',
            'OTA_AirLowFareSearchRS' => '\\dgsoft\\StructType\\DgOTA_AirLowFareSearchRS',
            'PricedItinerariesType' => '\\dgsoft\\StructType\\DgPricedItinerariesType',
            'PricedItinerary' => '\\dgsoft\\StructType\\DgPricedItinerary',
            'PricedItineraryForOWC' => '\\dgsoft\\StructType\\DgPricedItineraryForOWC',
            'PricedItineraryType' => '\\dgsoft\\StructType\\DgPricedItineraryType',
            'TicketingInfo' => '\\dgsoft\\StructType\\DgTicketingInfo',
            'DeliveryInfo' => '\\dgsoft\\StructType\\DgDeliveryInfo',
            'ArrayOfFreeBaggageLegendItem' => '\\dgsoft\\ArrayType\\DgArrayOfFreeBaggageLegendItem',
            'ArrayOfConnectedOperatingAirline' => '\\dgsoft\\ArrayType\\DgArrayOfConnectedOperatingAirline',
            'ConnectedOperatingAirline' => '\\dgsoft\\StructType\\DgConnectedOperatingAirline',
            'GetServiceFee' => '\\dgsoft\\StructType\\DgGetServiceFee',
            'ServiceFeeInfoRQ' => '\\dgsoft\\StructType\\DgServiceFeeInfoRQ',
            'GenericFlightRQ' => '\\dgsoft\\StructType\\DgGenericFlightRQ',
            'ServiceFeeInfoRQFlightInfo' => '\\dgsoft\\StructType\\DgServiceFeeInfoRQFlightInfo',
            'ServiceFeeInfoRQHotelInfo' => '\\dgsoft\\StructType\\DgServiceFeeInfoRQHotelInfo',
            'ServiceFeeInfoRQCarInfo' => '\\dgsoft\\StructType\\DgServiceFeeInfoRQCarInfo',
            'ServiceFeeInfoRQInsuranceInfo' => '\\dgsoft\\StructType\\DgServiceFeeInfoRQInsuranceInfo',
            'GetServiceFeeResponse' => '\\dgsoft\\StructType\\DgGetServiceFeeResponse',
            'ServiceFeeInfoRS' => '\\dgsoft\\StructType\\DgServiceFeeInfoRS',
            'GetBaggageInfo' => '\\dgsoft\\StructType\\DgGetBaggageInfo',
            'BaggageInfoRQ' => '\\dgsoft\\StructType\\DgBaggageInfoRQ',
            'PassengerInfo' => '\\dgsoft\\StructType\\DgPassengerInfo',
            'FrequentFlyerCardType' => '\\dgsoft\\StructType\\DgFrequentFlyerCardType',
            'GetBaggageInfoResponse' => '\\dgsoft\\StructType\\DgGetBaggageInfoResponse',
            'BaggageInfoRS' => '\\dgsoft\\StructType\\DgBaggageInfoRS',
            'AncillaryCatalogueItemsType' => '\\dgsoft\\StructType\\DgAncillaryCatalogueItemsType',
            'ArrayOfAncillaryCatalogueItemType' => '\\dgsoft\\ArrayType\\DgArrayOfAncillaryCatalogueItemType',
            'AncillaryCatalogueItemType' => '\\dgsoft\\StructType\\DgAncillaryCatalogueItemType',
            'AncillaryFaresType' => '\\dgsoft\\StructType\\DgAncillaryFaresType',
            'AncillaryFareType' => '\\dgsoft\\StructType\\DgAncillaryFareType',
            'AncillaryServiceFeesType' => '\\dgsoft\\StructType\\DgAncillaryServiceFeesType',
            'AncillaryServiceFeeType' => '\\dgsoft\\StructType\\DgAncillaryServiceFeeType',
            'ArrayOfRequiredParameter' => '\\dgsoft\\ArrayType\\DgArrayOfRequiredParameter',
            'RequiredParameter' => '\\dgsoft\\StructType\\DgRequiredParameter',
            'GetAncillaryInfo' => '\\dgsoft\\StructType\\DgGetAncillaryInfo',
            'AncillaryInfoRQ' => '\\dgsoft\\StructType\\DgAncillaryInfoRQ',
            'GetAncillaryInfoResponse' => '\\dgsoft\\StructType\\DgGetAncillaryInfoResponse',
            'AncillaryInfoRS' => '\\dgsoft\\StructType\\DgAncillaryInfoRS',
            'GetCompatibleLowestFaresForSunExpress' => '\\dgsoft\\StructType\\DgGetCompatibleLowestFaresForSunExpress',
            'FlightOptionRQ' => '\\dgsoft\\StructType\\DgFlightOptionRQ',
            'GetCompatibleLowestFaresForSunExpressResponse' => '\\dgsoft\\StructType\\DgGetCompatibleLowestFaresForSunExpressResponse',
            'GetServiceFeeV2' => '\\dgsoft\\StructType\\DgGetServiceFeeV2',
            'GetServiceFeeV2Response' => '\\dgsoft\\StructType\\DgGetServiceFeeV2Response',
            'GetPrice' => '\\dgsoft\\StructType\\DgGetPrice',
            'PriceInfoRQ' => '\\dgsoft\\StructType\\DgPriceInfoRQ',
            'GetPriceResponse' => '\\dgsoft\\StructType\\DgGetPriceResponse',
            'GetRequiredParametersForLCC' => '\\dgsoft\\StructType\\DgGetRequiredParametersForLCC',
            'RequiredParametersRQ' => '\\dgsoft\\StructType\\DgRequiredParametersRQ',
            'GetRequiredParametersForLCCResponse' => '\\dgsoft\\StructType\\DgGetRequiredParametersForLCCResponse',
            'RequiredParametersRS' => '\\dgsoft\\StructType\\DgRequiredParametersRS',
            'RequiredParametersData' => '\\dgsoft\\StructType\\DgRequiredParametersData',
            'ArrayOfLCCRequiredParameter' => '\\dgsoft\\ArrayType\\DgArrayOfLCCRequiredParameter',
            'LCCRequiredParameter' => '\\dgsoft\\StructType\\DgLCCRequiredParameter',
            'ArrayOfLCCSupportedCard' => '\\dgsoft\\ArrayType\\DgArrayOfLCCSupportedCard',
            'LCCSupportedCard' => '\\dgsoft\\StructType\\DgLCCSupportedCard',
            'ArrayOfLCCBaggageFee' => '\\dgsoft\\ArrayType\\DgArrayOfLCCBaggageFee',
            'LCCBaggageFee' => '\\dgsoft\\StructType\\DgLCCBaggageFee',
            'ArrayOfLCCOtherFee' => '\\dgsoft\\ArrayType\\DgArrayOfLCCOtherFee',
            'LCCOtherFee' => '\\dgsoft\\StructType\\DgLCCOtherFee',
            'ArrayOfLCCCheckInOption' => '\\dgsoft\\ArrayType\\DgArrayOfLCCCheckInOption',
            'LCCCheckInOption' => '\\dgsoft\\StructType\\DgLCCCheckInOption',
            'GetNextFlightResults' => '\\dgsoft\\StructType\\DgGetNextFlightResults',
            'GetNextFlightResultsResponse' => '\\dgsoft\\StructType\\DgGetNextFlightResultsResponse',
            'SearchFlightCalendar' => '\\dgsoft\\StructType\\DgSearchFlightCalendar',
            'SearchFlightCalendarResponse' => '\\dgsoft\\StructType\\DgSearchFlightCalendarResponse',
            'CheckETicket' => '\\dgsoft\\StructType\\DgCheckETicket',
            'OTA_AirCheckETicketRQ' => '\\dgsoft\\StructType\\DgOTA_AirCheckETicketRQ',
            'CheckETicketResponse' => '\\dgsoft\\StructType\\DgCheckETicketResponse',
            'OTA_AirCheckETicketRS' => '\\dgsoft\\StructType\\DgOTA_AirCheckETicketRS',
            'GetFlightRules' => '\\dgsoft\\StructType\\DgGetFlightRules',
            'OTA_AirRulesRQ' => '\\dgsoft\\StructType\\DgOTA_AirRulesRQ',
            'OTA_AirRulesRQRuleReqInfo' => '\\dgsoft\\StructType\\DgOTA_AirRulesRQRuleReqInfo',
            'OTA_AirRulesRQRuleReqInfoSubSection' => '\\dgsoft\\StructType\\DgOTA_AirRulesRQRuleReqInfoSubSection',
            'GetFlightRulesResponse' => '\\dgsoft\\StructType\\DgGetFlightRulesResponse',
            'OTA_AirRulesRS' => '\\dgsoft\\StructType\\DgOTA_AirRulesRS',
            'RuleLink' => '\\dgsoft\\StructType\\DgRuleLink',
            'BookFlight' => '\\dgsoft\\StructType\\DgBookFlight',
            'OTA_AirBookRQ' => '\\dgsoft\\StructType\\DgOTA_AirBookRQ',
            'PriceInfo' => '\\dgsoft\\StructType\\DgPriceInfo',
            'PricingPref' => '\\dgsoft\\StructType\\DgPricingPref',
            'Receipt' => '\\dgsoft\\StructType\\DgReceipt',
            'PaymentText' => '\\dgsoft\\StructType\\DgPaymentText',
            'LCCUserLogin' => '\\dgsoft\\StructType\\DgLCCUserLogin',
            'Ticketing' => '\\dgsoft\\StructType\\DgTicketing',
            'TicketingVendor' => '\\dgsoft\\StructType\\DgTicketingVendor',
            'PricingSystem' => '\\dgsoft\\StructType\\DgPricingSystem',
            'InsurancePlan' => '\\dgsoft\\StructType\\DgInsurancePlan',
            'RelatedMember' => '\\dgsoft\\StructType\\DgRelatedMember',
            'BookFlightResponse' => '\\dgsoft\\StructType\\DgBookFlightResponse',
            'BookFlightWithRecommendation' => '\\dgsoft\\StructType\\DgBookFlightWithRecommendation',
            'BookFlightWithRecommendationResponse' => '\\dgsoft\\StructType\\DgBookFlightWithRecommendationResponse',
            'CreateTicket' => '\\dgsoft\\StructType\\DgCreateTicket',
            'CreateTicketResponse' => '\\dgsoft\\StructType\\DgCreateTicketResponse',
            'GetPNR' => '\\dgsoft\\StructType\\DgGetPNR',
            'OTA_ReadRQ' => '\\dgsoft\\StructType\\DgOTA_ReadRQ',
            'ReadRequests' => '\\dgsoft\\StructType\\DgReadRequests',
            'GlobalReservationReadRequest' => '\\dgsoft\\StructType\\DgGlobalReservationReadRequest',
            'GolfReadRequest' => '\\dgsoft\\StructType\\DgGolfReadRequest',
            'CruiseReadRequest' => '\\dgsoft\\StructType\\DgCruiseReadRequest',
            'SelectedSailing' => '\\dgsoft\\StructType\\DgSelectedSailing',
            'HotelReadRequest' => '\\dgsoft\\StructType\\DgHotelReadRequest',
            'UserID' => '\\dgsoft\\StructType\\DgUserID',
            'VehicleReadRequest' => '\\dgsoft\\StructType\\DgVehicleReadRequest',
            'AirReadRequest' => '\\dgsoft\\StructType\\DgAirReadRequest',
            'QueueInfo' => '\\dgsoft\\StructType\\DgQueueInfo',
            'PkgReadRequest' => '\\dgsoft\\StructType\\DgPkgReadRequest',
            'ReadRequest' => '\\dgsoft\\StructType\\DgReadRequest',
            'VehicleRetrieveResRQCoreType' => '\\dgsoft\\StructType\\DgVehicleRetrieveResRQCoreType',
            'VehicleRetrieveResRQAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleRetrieveResRQAdditionalInfoType',
            'GetPNRResponse' => '\\dgsoft\\StructType\\DgGetPNRResponse',
            'GetPNRPrice' => '\\dgsoft\\StructType\\DgGetPNRPrice',
            'GetPNRPriceResponse' => '\\dgsoft\\StructType\\DgGetPNRPriceResponse',
            'EditPNR' => '\\dgsoft\\StructType\\DgEditPNR',
            'EditPNRRQ' => '\\dgsoft\\StructType\\DgEditPNRRQ',
            'PassengerDetailChanges' => '\\dgsoft\\StructType\\DgPassengerDetailChanges',
            'ArrayOfChangeDetail' => '\\dgsoft\\ArrayType\\DgArrayOfChangeDetail',
            'ChangeDetail' => '\\dgsoft\\StructType\\DgChangeDetail',
            'ArrayOfSpecialRequestChange' => '\\dgsoft\\ArrayType\\DgArrayOfSpecialRequestChange',
            'SpecialRequestChange' => '\\dgsoft\\StructType\\DgSpecialRequestChange',
            'ArrayOfPNRRemarkChange' => '\\dgsoft\\ArrayType\\DgArrayOfPNRRemarkChange',
            'PNRRemarkChange' => '\\dgsoft\\StructType\\DgPNRRemarkChange',
            'ArrayOfOSIElementChange' => '\\dgsoft\\ArrayType\\DgArrayOfOSIElementChange',
            'OSIElementChange' => '\\dgsoft\\StructType\\DgOSIElementChange',
            'EditPNRResponse' => '\\dgsoft\\StructType\\DgEditPNRResponse',
            'EditPnrRS' => '\\dgsoft\\StructType\\DgEditPnrRS',
            'GetLastTicketingDate' => '\\dgsoft\\StructType\\DgGetLastTicketingDate',
            'GetLastTicketingDateResponse' => '\\dgsoft\\StructType\\DgGetLastTicketingDateResponse',
            'LastTicketingDateRS' => '\\dgsoft\\StructType\\DgLastTicketingDateRS',
            'ArrayOfLastTicketingDateData' => '\\dgsoft\\ArrayType\\DgArrayOfLastTicketingDateData',
            'LastTicketingDateData' => '\\dgsoft\\StructType\\DgLastTicketingDateData',
            'GetSeatMap' => '\\dgsoft\\StructType\\DgGetSeatMap',
            'OTA_AirSeatMapRQ' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQ',
            'ArrayOfFrequentFlyerCardsWithPassengerForSeatMap' => '\\dgsoft\\ArrayType\\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap',
            'FrequentFlyerCardsWithPassengerForSeatMap' => '\\dgsoft\\StructType\\DgFrequentFlyerCardsWithPassengerForSeatMap',
            'ArrayOfFlayerCardForSeatMap' => '\\dgsoft\\ArrayType\\DgArrayOfFlayerCardForSeatMap',
            'FlayerCardForSeatMap' => '\\dgsoft\\StructType\\DgFlayerCardForSeatMap',
            'ArrayOfOTA_AirSeatMapRQSeatMapRequest' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_AirSeatMapRQSeatMapRequest',
            'OTA_AirSeatMapRQSeatMapRequest' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQSeatMapRequest',
            'OTA_AirSeatMapRQSeatMapRequestSeatDetails' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails',
            'OTA_AirSeatMapRQSeatMapRequestSeatDetailsCabinClass' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQSeatMapRequestSeatDetailsCabinClass',
            'ArrayOfOTA_AirSeatMapRQSeatMapRequestSeatDetailsResBookDesignation' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_AirSeatMapRQSeatMapRequestSeatDetailsResBookDesignation',
            'OTA_AirSeatMapRQSeatMapRequestSeatDetailsResBookDesignation' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQSeatMapRequestSeatDetailsResBookDesignation',
            'ArrayOfOTA_AirSeatMapRQAirTraveler' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_AirSeatMapRQAirTraveler',
            'OTA_AirSeatMapRQAirTraveler' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQAirTraveler',
            'OTA_AirSeatMapRQAirTravelerCustLoyalty' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQAirTravelerCustLoyalty',
            'OTA_AirSeatMapRQAirTravelerTravelerRefNumber' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRQAirTravelerTravelerRefNumber',
            'GetSeatMapResponse' => '\\dgsoft\\StructType\\DgGetSeatMapResponse',
            'OTA_AirSeatMapRS' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRS',
            'OTA_AirSeatMapRSSeatMapResponses' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRSSeatMapResponses',
            'OTA_AirSeatMapRSSeatMapResponsesSeatMapResponse' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRSSeatMapResponsesSeatMapResponse',
            'OTA_AirSeatMapRSSeatMapResponsesSeatMapResponseFlightSegmentInfo' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRSSeatMapResponsesSeatMapResponseFlightSegmentInfo',
            'ArrayOfWarningType1' => '\\dgsoft\\ArrayType\\DgArrayOfWarningType1',
            'SeatMapDetailsType' => '\\dgsoft\\StructType\\DgSeatMapDetailsType',
            'CabinClassType' => '\\dgsoft\\StructType\\DgCabinClassType',
            'ArrayOfRowDetailsType' => '\\dgsoft\\ArrayType\\DgArrayOfRowDetailsType',
            'RowDetailsType' => '\\dgsoft\\StructType\\DgRowDetailsType',
            'ArrayOfRowDetailsTypeAirSeat' => '\\dgsoft\\ArrayType\\DgArrayOfRowDetailsTypeAirSeat',
            'RowDetailsTypeAirSeat' => '\\dgsoft\\StructType\\DgRowDetailsTypeAirSeat',
            'RowDetailsTypeAirRowCharacteristics' => '\\dgsoft\\StructType\\DgRowDetailsTypeAirRowCharacteristics',
            'ColumnDetailsTypeAirColumnCharacteristics' => '\\dgsoft\\StructType\\DgColumnDetailsTypeAirColumnCharacteristics',
            'ArrayOfColumnDetailsType' => '\\dgsoft\\ArrayType\\DgArrayOfColumnDetailsType',
            'ColumnDetailsType' => '\\dgsoft\\StructType\\DgColumnDetailsType',
            'ArrayOfOTA_AirSeatMapRSSeatMapResponsesAirTraveler' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_AirSeatMapRSSeatMapResponsesAirTraveler',
            'OTA_AirSeatMapRSSeatMapResponsesAirTraveler' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRSSeatMapResponsesAirTraveler',
            'OTA_AirSeatMapRSSeatMapResponsesAirTravelerCustLoyalty' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRSSeatMapResponsesAirTravelerCustLoyalty',
            'OTA_AirSeatMapRSSeatMapResponsesAirTravelerTravelerRefNumber' => '\\dgsoft\\StructType\\DgOTA_AirSeatMapRSSeatMapResponsesAirTravelerTravelerRefNumber',
            'SearchFlightTimeTable' => '\\dgsoft\\StructType\\DgSearchFlightTimeTable',
            'OTA_AirScheduleRQ' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRQ',
            'OTA_AirScheduleRQFlightTypePref' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRQFlightTypePref',
            'SearchFlightTimeTableResponse' => '\\dgsoft\\StructType\\DgSearchFlightTimeTableResponse',
            'OTA_AirScheduleRS' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRS',
            'OTA_AirScheduleRSAirItinerariesType' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSAirItinerariesType',
            'OTA_AirScheduleRSAirItineraryType' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSAirItineraryType',
            'OTA_AirScheduleRSOriginDestinationOptions' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSOriginDestinationOptions',
            'OTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption',
            'AvailableDate' => '\\dgsoft\\StructType\\DgAvailableDate',
            'ArrayOfDateTime' => '\\dgsoft\\ArrayType\\DgArrayOfDateTime',
            'OTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionFlightSegment' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionFlightSegment',
            'MarketingCabinType' => '\\dgsoft\\StructType\\DgMarketingCabinType',
            'CabinAvailabilityType' => '\\dgsoft\\StructType\\DgCabinAvailabilityType',
            'CabinAvailabilityTypeMeal' => '\\dgsoft\\StructType\\DgCabinAvailabilityTypeMeal',
            'CabinAvailabilityTypeBaggageAllowance' => '\\dgsoft\\StructType\\DgCabinAvailabilityTypeBaggageAllowance',
            'OTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionFlightSegmentBookingClass' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionFlightSegmentBookingClass',
            'OTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionFlightSegmentTrafficRestrictionInfo' => '\\dgsoft\\StructType\\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionFlightSegmentTrafficRestrictionInfo',
            'GetCancelPolicyText' => '\\dgsoft\\StructType\\DgGetCancelPolicyText',
            'GetCancelPolicyTextResponse' => '\\dgsoft\\StructType\\DgGetCancelPolicyTextResponse',
            'SearchHotel' => '\\dgsoft\\StructType\\DgSearchHotel',
            'OTA_HotelSearchRQ' => '\\dgsoft\\StructType\\DgOTA_HotelSearchRQ',
            'HotelSearchCriteriaType' => '\\dgsoft\\StructType\\DgHotelSearchCriteriaType',
            'Criterion' => '\\dgsoft\\StructType\\DgCriterion',
            'HotelSearchCriterionType' => '\\dgsoft\\StructType\\DgHotelSearchCriterionType',
            'ItemSearchCriterionType' => '\\dgsoft\\StructType\\DgItemSearchCriterionType',
            'RefPoint' => '\\dgsoft\\StructType\\DgRefPoint',
            'CodeRef' => '\\dgsoft\\StructType\\DgCodeRef',
            'HotelRef' => '\\dgsoft\\StructType\\DgHotelRef',
            'Radius' => '\\dgsoft\\StructType\\DgRadius',
            'ArrayOfRatePlanCandidatesTypeRatePlanCandidate' => '\\dgsoft\\ArrayType\\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate',
            'RatePlanCandidate' => '\\dgsoft\\StructType\\DgRatePlanCandidate',
            'ArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef' => '\\dgsoft\\ArrayType\\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef',
            'ArrayOfRoomStayCandidateType' => '\\dgsoft\\ArrayType\\DgArrayOfRoomStayCandidateType',
            'RoomStayCandidateType' => '\\dgsoft\\StructType\\DgRoomStayCandidateType',
            'SearchHotelResponse' => '\\dgsoft\\StructType\\DgSearchHotelResponse',
            'OTA_HotelSearchRS' => '\\dgsoft\\StructType\\DgOTA_HotelSearchRS',
            'ArrayOfAreasTypeArea' => '\\dgsoft\\ArrayType\\DgArrayOfAreasTypeArea',
            'AreasTypeArea' => '\\dgsoft\\StructType\\DgAreasTypeArea',
            'ArrayOfPropertiesTypeProperty' => '\\dgsoft\\ArrayType\\DgArrayOfPropertiesTypeProperty',
            'PropertiesTypeProperty' => '\\dgsoft\\StructType\\DgPropertiesTypeProperty',
            'GetHotelInfo' => '\\dgsoft\\StructType\\DgGetHotelInfo',
            'OTA_HotelInfoRQ' => '\\dgsoft\\StructType\\DgOTA_HotelInfoRQ',
            'GetHotelInfoResponse' => '\\dgsoft\\StructType\\DgGetHotelInfoResponse',
            'SearchHotelRooms' => '\\dgsoft\\StructType\\DgSearchHotelRooms',
            'OTA_HotelAvailRQ' => '\\dgsoft\\StructType\\DgOTA_HotelAvailRQ',
            'SearchHotelRoomsResponse' => '\\dgsoft\\StructType\\DgSearchHotelRoomsResponse',
            'OTA_HotelAvailRS' => '\\dgsoft\\StructType\\DgOTA_HotelAvailRS',
            'RoomStays' => '\\dgsoft\\StructType\\DgRoomStays',
            'ArrayOfProfilesTypeProfileInfo1' => '\\dgsoft\\ArrayType\\DgArrayOfProfilesTypeProfileInfo1',
            'ProfilesTypeProfileInfo' => '\\dgsoft\\StructType\\DgProfilesTypeProfileInfo',
            'ArrayOfHotelSearchCriterionType' => '\\dgsoft\\ArrayType\\DgArrayOfHotelSearchCriterionType',
            'ArrayOfServicesTypeService1' => '\\dgsoft\\ArrayType\\DgArrayOfServicesTypeService1',
            'ServicesTypeService' => '\\dgsoft\\StructType\\DgServicesTypeService',
            'ArrayOfOTA_HotelAvailRSHotelStaysHotelStay' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay',
            'OTA_HotelAvailRSHotelStaysHotelStay' => '\\dgsoft\\StructType\\DgOTA_HotelAvailRSHotelStaysHotelStay',
            'GetHotelRoomRules' => '\\dgsoft\\StructType\\DgGetHotelRoomRules',
            'OTA_HotelRoomRuleRQ' => '\\dgsoft\\StructType\\DgOTA_HotelRoomRuleRQ',
            'GetHotelRoomRulesResponse' => '\\dgsoft\\StructType\\DgGetHotelRoomRulesResponse',
            'BookHotel' => '\\dgsoft\\StructType\\DgBookHotel',
            'OTA_HotelResRQ' => '\\dgsoft\\StructType\\DgOTA_HotelResRQ',
            'BookHotelResponse' => '\\dgsoft\\StructType\\DgBookHotelResponse',
            'GetHotelPNR' => '\\dgsoft\\StructType\\DgGetHotelPNR',
            'GetHotelPNRResponse' => '\\dgsoft\\StructType\\DgGetHotelPNRResponse',
            'SearchCar' => '\\dgsoft\\StructType\\DgSearchCar',
            'OTA_VehAvailRateRQ' => '\\dgsoft\\StructType\\DgOTA_VehAvailRateRQ',
            'OTA_VehAvailRateRQVehAvailRQCore' => '\\dgsoft\\StructType\\DgOTA_VehAvailRateRQVehAvailRQCore',
            'VehicleAvailRQCoreType' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreType',
            'VehicleAvailRQCoreTypeVendorPrefs' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeVendorPrefs',
            'VehicleAvailRQCoreTypeVendorPrefsVendorPref' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeVendorPrefsVendorPref',
            'ArrayOfVehicleAvailRQCoreTypeVehPref' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleAvailRQCoreTypeVehPref',
            'VehicleAvailRQCoreTypeVehPref' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeVehPref',
            'VehicleAvailRQCoreTypeDriverType' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeDriverType',
            'VehicleAvailRQCoreTypeRateQualifier' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeRateQualifier',
            'VehicleAvailRQCoreTypeRateRange' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeRateRange',
            'ArrayOfVehicleAvailRQCoreTypeSpecialEquipPref' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleAvailRQCoreTypeSpecialEquipPref',
            'VehicleAvailRQCoreTypeSpecialEquipPref' => '\\dgsoft\\StructType\\DgVehicleAvailRQCoreTypeSpecialEquipPref',
            'VehicleAvailRQAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleAvailRQAdditionalInfoType',
            'ArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleAvailRQAdditionalInfoTypeCoveragePref',
            'VehicleAvailRQAdditionalInfoTypeCoveragePref' => '\\dgsoft\\StructType\\DgVehicleAvailRQAdditionalInfoTypeCoveragePref',
            'VehicleArrivalDetailsType' => '\\dgsoft\\StructType\\DgVehicleArrivalDetailsType',
            'SearchCarResponse' => '\\dgsoft\\StructType\\DgSearchCarResponse',
            'OTA_VehAvailRateRS' => '\\dgsoft\\StructType\\DgOTA_VehAvailRateRS',
            'VehicleAvailRSCoreType' => '\\dgsoft\\StructType\\DgVehicleAvailRSCoreType',
            'ArrayOfVehicleVendorAvailabilityType' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleVendorAvailabilityType',
            'VehicleVendorAvailabilityType' => '\\dgsoft\\StructType\\DgVehicleVendorAvailabilityType',
            'VehicleVendorAvailabilityTypeVehAvails' => '\\dgsoft\\StructType\\DgVehicleVendorAvailabilityTypeVehAvails',
            'VehicleVendorAvailabilityTypeVehAvailsVehAvail' => '\\dgsoft\\StructType\\DgVehicleVendorAvailabilityTypeVehAvailsVehAvail',
            'VehicleAvailCoreType' => '\\dgsoft\\StructType\\DgVehicleAvailCoreType',
            'VehicleAvailCoreTypeTotalCharge' => '\\dgsoft\\StructType\\DgVehicleAvailCoreTypeTotalCharge',
            'VehicleAvailCoreTypeReference' => '\\dgsoft\\StructType\\DgVehicleAvailCoreTypeReference',
            'VehicleAvailCoreTypeVendor' => '\\dgsoft\\StructType\\DgVehicleAvailCoreTypeVendor',
            'VehicleAvailCoreTypeVendorLocation' => '\\dgsoft\\StructType\\DgVehicleAvailCoreTypeVendorLocation',
            'VehicleAvailCoreTypeDropOffLocation' => '\\dgsoft\\StructType\\DgVehicleAvailCoreTypeDropOffLocation',
            'VehicleAvailAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleAvailAdditionalInfoType',
            'VehicleVendorAvailabilityTypeVehAvailsVehAvailAdvanceBooking' => '\\dgsoft\\StructType\\DgVehicleVendorAvailabilityTypeVehAvailsVehAvailAdvanceBooking',
            'VehicleAvailVendorInfoType' => '\\dgsoft\\StructType\\DgVehicleAvailVendorInfoType',
            'ArrayOfVendorMessageType' => '\\dgsoft\\ArrayType\\DgArrayOfVendorMessageType',
            'VendorMessageType' => '\\dgsoft\\StructType\\DgVendorMessageType',
            'VehicleAvailRSAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleAvailRSAdditionalInfoType',
            'SearchCarVendor' => '\\dgsoft\\StructType\\DgSearchCarVendor',
            'OTA_VehAvailVendorRQ' => '\\dgsoft\\StructType\\DgOTA_VehAvailVendorRQ',
            'SearchCarVendorResponse' => '\\dgsoft\\StructType\\DgSearchCarVendorResponse',
            'GetCarCompanyLocations' => '\\dgsoft\\StructType\\DgGetCarCompanyLocations',
            'OTA_VehLocSearchRQ' => '\\dgsoft\\StructType\\DgOTA_VehLocSearchRQ',
            'GetCarCompanyLocationsResponse' => '\\dgsoft\\StructType\\DgGetCarCompanyLocationsResponse',
            'OTA_VehLocSearchRS' => '\\dgsoft\\StructType\\DgOTA_VehLocSearchRS',
            'OTA_VehLocSearchRSVehMatchedLocs' => '\\dgsoft\\StructType\\DgOTA_VehLocSearchRSVehMatchedLocs',
            'VehicleMatchedLocationType' => '\\dgsoft\\StructType\\DgVehicleMatchedLocationType',
            'GetCarRules' => '\\dgsoft\\StructType\\DgGetCarRules',
            'OTA_VehRateRuleRQ' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRQ',
            'OTA_VehRateRuleRQRentalInfo' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRQRentalInfo',
            'ArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref',
            'OTA_VehRateRuleRQRentalInfoSpecialEquipPref' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRQRentalInfoSpecialEquipPref',
            'OTA_VehRateRuleRQRentalInfoCustLoyalty' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRQRentalInfoCustLoyalty',
            'OTA_VehRateRuleRQRentalInfoRateQualifier' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRQRentalInfoRateQualifier',
            'GetCarRulesResponse' => '\\dgsoft\\StructType\\DgGetCarRulesResponse',
            'OTA_VehRateRuleRS' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRS',
            'VendorMessagesType' => '\\dgsoft\\StructType\\DgVendorMessagesType',
            'OTA_VehRateRuleRSRateRules' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRules',
            'OTA_VehRateRuleRSRateRulesAdvanceBooking' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesAdvanceBooking',
            'OTA_VehRateRuleRSRateRulesPickupReturnRules' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPickupReturnRules',
            'OTA_VehRateRuleRSRateRulesPickupReturnRulesEarliestPickup' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPickupReturnRulesEarliestPickup',
            'OTA_VehRateRuleRSRateRulesPickupReturnRulesLatestPickup' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPickupReturnRulesLatestPickup',
            'OTA_VehRateRuleRSRateRulesPickupReturnRulesLatestReturn' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPickupReturnRulesLatestReturn',
            'OTA_VehRateRuleRSRateRulesRateGuarantee' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesRateGuarantee',
            'OTA_VehRateRuleRSRateRulesPaymentRules' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPaymentRules',
            'PaymentRulesType' => '\\dgsoft\\StructType\\DgPaymentRulesType',
            'OTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments',
            'OTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment',
            'OTA_VehRateRuleRSRateRulesCancelPenaltyInfo' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesCancelPenaltyInfo',
            'OTA_VehRateRuleRSRateRulesCancelPenaltyInfoDeadline' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesCancelPenaltyInfoDeadline',
            'OTA_VehRateRuleRSRateRulesCancelPenaltyInfoPenaltyFee' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesCancelPenaltyInfoPenaltyFee',
            'OTA_VehRateRuleRSRateRulesRateDeposit' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRateRulesRateDeposit',
            'OTA_VehRateRuleRSRentalRate' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSRentalRate',
            'OTA_VehRateRuleRSLocationDetails' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSLocationDetails',
            'OTA_VehRateRuleRSFees' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSFees',
            'OTA_VehRateRuleRSTotalCharge' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSTotalCharge',
            'OTA_VehRateRuleRSVehRentalCore' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSVehRentalCore',
            'OTA_VehRateRuleRSVehicle' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSVehicle',
            'OTA_VehRateRuleRSPricedCoverages' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSPricedCoverages',
            'OTA_VehRateRuleRSPricedEquips' => '\\dgsoft\\StructType\\DgOTA_VehRateRuleRSPricedEquips',
            'BookCar' => '\\dgsoft\\StructType\\DgBookCar',
            'OTA_VehResRQ' => '\\dgsoft\\StructType\\DgOTA_VehResRQ',
            'OTA_VehResRQVehResRQCore' => '\\dgsoft\\StructType\\DgOTA_VehResRQVehResRQCore',
            'VehicleReservationRQCoreType' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreType',
            'VehicleReservationRQCoreTypeDriverType' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreTypeDriverType',
            'VehicleReservationRQCoreTypeSpecialEquipPrefs' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreTypeSpecialEquipPrefs',
            'VehicleReservationRQCoreTypeSpecialEquipPrefsSpecialEquipPref' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreTypeSpecialEquipPrefsSpecialEquipPref',
            'VehicleReservationRQCoreTypeRateDistance' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreTypeRateDistance',
            'VehicleReservationRQCoreTypeTotalCharge' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreTypeTotalCharge',
            'VehicleReservationRQCoreTypeQueue' => '\\dgsoft\\StructType\\DgVehicleReservationRQCoreTypeQueue',
            'OTA_VehResRQVehResRQInfo' => '\\dgsoft\\StructType\\DgOTA_VehResRQVehResRQInfo',
            'VehicleReservationRQAdditionalInfoType' => '\\dgsoft\\StructType\\DgVehicleReservationRQAdditionalInfoType',
            'ArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref' => '\\dgsoft\\ArrayType\\DgArrayOfVehicleReservationRQAdditionalInfoTypeCoveragePref',
            'VehicleReservationRQAdditionalInfoTypeCoveragePref' => '\\dgsoft\\StructType\\DgVehicleReservationRQAdditionalInfoTypeCoveragePref',
            'VehicleReservationRQAdditionalInfoTypeRentalPaymentPref' => '\\dgsoft\\StructType\\DgVehicleReservationRQAdditionalInfoTypeRentalPaymentPref',
            'VehicleReservationRQAdditionalInfoTypeReference' => '\\dgsoft\\StructType\\DgVehicleReservationRQAdditionalInfoTypeReference',
            'BookCarResponse' => '\\dgsoft\\StructType\\DgBookCarResponse',
            'GetCarPNR' => '\\dgsoft\\StructType\\DgGetCarPNR',
            'GetCarPNRResponse' => '\\dgsoft\\StructType\\DgGetCarPNRResponse',
            'SearchInsurancePlans' => '\\dgsoft\\StructType\\DgSearchInsurancePlans',
            'OTA_InsurancePlanSearchRQ' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQ',
            'ArrayOfOTA_InsurancePlanSearchRQCoveragePreference' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference',
            'OTA_InsurancePlanSearchRQCoveragePreference' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQCoveragePreference',
            'CoverageLimitType' => '\\dgsoft\\StructType\\DgCoverageLimitType',
            'CoverageLimitTypeDeductible' => '\\dgsoft\\StructType\\DgCoverageLimitTypeDeductible',
            'CoverageLimitTypePolicyLimit' => '\\dgsoft\\StructType\\DgCoverageLimitTypePolicyLimit',
            'CoverageLimitTypeIndividualLimit' => '\\dgsoft\\StructType\\DgCoverageLimitTypeIndividualLimit',
            'OTA_InsurancePlanSearchRQSearchTripInfo' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQSearchTripInfo',
            'OTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost',
            'TimeDurationType' => '\\dgsoft\\StructType\\DgTimeDurationType',
            'ArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip' => '\\dgsoft\\ArrayType\\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip',
            'OTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip',
            'TripFeaturesType' => '\\dgsoft\\StructType\\DgTripFeaturesType',
            'ArrayOfTripFeaturesTypeDestination' => '\\dgsoft\\ArrayType\\DgArrayOfTripFeaturesTypeDestination',
            'TripFeaturesTypeDestination' => '\\dgsoft\\StructType\\DgTripFeaturesTypeDestination',
            'ArrayOfString4' => '\\dgsoft\\ArrayType\\DgArrayOfString4',
            'ArrayOfCompanyNameType' => '\\dgsoft\\ArrayType\\DgArrayOfCompanyNameType',
            'OTA_InsurancePlanSearchRQSearchFlightInfo' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQSearchFlightInfo',
            'OTA_InsurancePlanSearchRQSearchTravInfo' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRQSearchTravInfo',
            'ArrayOfSearchTravelerType' => '\\dgsoft\\ArrayType\\DgArrayOfSearchTravelerType',
            'SearchTravelerType' => '\\dgsoft\\StructType\\DgSearchTravelerType',
            'SearchTravelerTypeCitizenCountryName' => '\\dgsoft\\StructType\\DgSearchTravelerTypeCitizenCountryName',
            'IndCoverageReqsType' => '\\dgsoft\\StructType\\DgIndCoverageReqsType',
            'IndCoverageReqsTypeIndTripCost' => '\\dgsoft\\StructType\\DgIndCoverageReqsTypeIndTripCost',
            'IndCoverageReqsTypeFlightAccidentAmount' => '\\dgsoft\\StructType\\DgIndCoverageReqsTypeFlightAccidentAmount',
            'ArrayOfIndCoverageReqsTypeLuggageItem' => '\\dgsoft\\ArrayType\\DgArrayOfIndCoverageReqsTypeLuggageItem',
            'IndCoverageReqsTypeLuggageItem' => '\\dgsoft\\StructType\\DgIndCoverageReqsTypeLuggageItem',
            'IndCoverageReqsTypeLuggageItemItemDeclaredValue' => '\\dgsoft\\StructType\\DgIndCoverageReqsTypeLuggageItemItemDeclaredValue',
            'IndCoverageReqsTypeLuggageItemLuggagePremium' => '\\dgsoft\\StructType\\DgIndCoverageReqsTypeLuggageItemLuggagePremium',
            'ArrayOfIndCoverageReqsTypePreexistingCondition' => '\\dgsoft\\ArrayType\\DgArrayOfIndCoverageReqsTypePreexistingCondition',
            'IndCoverageReqsTypePreexistingCondition' => '\\dgsoft\\StructType\\DgIndCoverageReqsTypePreexistingCondition',
            'BoundedAffiliationsType' => '\\dgsoft\\StructType\\DgBoundedAffiliationsType',
            'SearchInsurancePlansResponse' => '\\dgsoft\\StructType\\DgSearchInsurancePlansResponse',
            'OTA_InsurancePlanSearchRS' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRS',
            'OTA_InsurancePlanSearchRSAvailablePlans' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRSAvailablePlans',
            'OTA_InsurancePlanSearchRSAvailablePlansAvailablePlan' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRSAvailablePlansAvailablePlan',
            'OTA_InsurancePlanSearchRSAvailablePlansAvailablePlanPlanDetail' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRSAvailablePlansAvailablePlanPlanDetail',
            'OTA_InsurancePlanSearchRSAvailablePlansAvailablePlanProviderDetail' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRSAvailablePlansAvailablePlanProviderDetail',
            'OTA_InsurancePlanSearchRSAvailablePlansAvailablePlanUnderwriterDetail' => '\\dgsoft\\StructType\\DgOTA_InsurancePlanSearchRSAvailablePlansAvailablePlanUnderwriterDetail',
            'PlanCostType' => '\\dgsoft\\StructType\\DgPlanCostType',
            'PlanCostTypeBasePremium' => '\\dgsoft\\StructType\\DgPlanCostTypeBasePremium',
            'ArrayOfFeeType1' => '\\dgsoft\\ArrayType\\DgArrayOfFeeType1',
            'ArrayOfPlanRestrictionTypePlanRestriction' => '\\dgsoft\\ArrayType\\DgArrayOfPlanRestrictionTypePlanRestriction',
            'PlanRestrictionTypePlanRestriction' => '\\dgsoft\\StructType\\DgPlanRestrictionTypePlanRestriction',
            'BookInsurance' => '\\dgsoft\\StructType\\DgBookInsurance',
            'OTA_InsuranceBookRQ' => '\\dgsoft\\StructType\\DgOTA_InsuranceBookRQ',
            'OTA_InsuranceBookRQPlanForBookRQ' => '\\dgsoft\\StructType\\DgOTA_InsuranceBookRQPlanForBookRQ',
            'InsCoverageType' => '\\dgsoft\\StructType\\DgInsCoverageType',
            'ArrayOfCoveredTravelerType' => '\\dgsoft\\ArrayType\\DgArrayOfCoveredTravelerType',
            'CoveredTravelerType' => '\\dgsoft\\StructType\\DgCoveredTravelerType',
            'CoveredTravelerTypeCoveredPerson' => '\\dgsoft\\StructType\\DgCoveredTravelerTypeCoveredPerson',
            'CoveredTravelerTypeCitizenCountryName' => '\\dgsoft\\StructType\\DgCoveredTravelerTypeCitizenCountryName',
            'CoveredTravelerTypeBeneficiary' => '\\dgsoft\\StructType\\DgCoveredTravelerTypeBeneficiary',
            'CoveredTravelerTypeBeneficiaryName' => '\\dgsoft\\StructType\\DgCoveredTravelerTypeBeneficiaryName',
            'InsCoverageDetailType' => '\\dgsoft\\StructType\\DgInsCoverageDetailType',
            'ArrayOfCoverageLimitType' => '\\dgsoft\\ArrayType\\DgArrayOfCoverageLimitType',
            'InsCoverageDetailTypeTotalTripQuantity' => '\\dgsoft\\StructType\\DgInsCoverageDetailTypeTotalTripQuantity',
            'InsCoverageDetailTypeTotalTripCost' => '\\dgsoft\\StructType\\DgInsCoverageDetailTypeTotalTripCost',
            'ArrayOfInsCoverageDetailTypeCoveredTrip' => '\\dgsoft\\ArrayType\\DgArrayOfInsCoverageDetailTypeCoveredTrip',
            'InsCoverageDetailTypeCoveredTrip' => '\\dgsoft\\StructType\\DgInsCoverageDetailTypeCoveredTrip',
            'DistribPrefType' => '\\dgsoft\\StructType\\DgDistribPrefType',
            'InsuranceCustomerType' => '\\dgsoft\\StructType\\DgInsuranceCustomerType',
            'BookInsuranceResponse' => '\\dgsoft\\StructType\\DgBookInsuranceResponse',
            'OTA_InsuranceBookRS' => '\\dgsoft\\StructType\\DgOTA_InsuranceBookRS',
            'OTA_InsuranceBookRSPlanForBookRS' => '\\dgsoft\\StructType\\DgOTA_InsuranceBookRSPlanForBookRS',
            'OTA_InsuranceBookRSPlanForBookRSPolicyDetail' => '\\dgsoft\\StructType\\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail',
            'Book' => '\\dgsoft\\StructType\\DgBook',
            'BookBasketRQ' => '\\dgsoft\\StructType\\DgBookBasketRQ',
            'FlightReservation' => '\\dgsoft\\StructType\\DgFlightReservation',
            'HotelReservation' => '\\dgsoft\\StructType\\DgHotelReservation',
            'CarReservation' => '\\dgsoft\\StructType\\DgCarReservation',
            'InsuranceReservation' => '\\dgsoft\\StructType\\DgInsuranceReservation',
            'BookResponse' => '\\dgsoft\\StructType\\DgBookResponse',
            'BookBasketRS' => '\\dgsoft\\StructType\\DgBookBasketRS',
            'FullFilment' => '\\dgsoft\\StructType\\DgFullFilment',
            'GetBasketPNR' => '\\dgsoft\\StructType\\DgGetBasketPNR',
            'GetBasketPNRResponse' => '\\dgsoft\\StructType\\DgGetBasketPNRResponse',
            'ExecuteCommand' => '\\dgsoft\\StructType\\DgExecuteCommand',
            'AmadeusAPICommandRQ' => '\\dgsoft\\StructType\\DgAmadeusAPICommandRQ',
            'ExecuteCommandResponse' => '\\dgsoft\\StructType\\DgExecuteCommandResponse',
            'AmadeusAPICommandRS' => '\\dgsoft\\StructType\\DgAmadeusAPICommandRS',
            'GetUser' => '\\dgsoft\\StructType\\DgGetUser',
            'GetUserRQ' => '\\dgsoft\\StructType\\DgGetUserRQ',
            'GetUserResponse' => '\\dgsoft\\StructType\\DgGetUserResponse',
            'GetUserRS' => '\\dgsoft\\StructType\\DgGetUserRS',
            'User' => '\\dgsoft\\StructType\\DgUser',
            'PassengerDB' => '\\dgsoft\\StructType\\DgPassengerDB',
            'Person' => '\\dgsoft\\StructType\\DgPerson',
            'Entity' => '\\dgsoft\\StructType\\DgEntity',
            'DBBaseEntity' => '\\dgsoft\\StructType\\DgDBBaseEntity',
            'GenericItem' => '\\dgsoft\\StructType\\DgGenericItem',
            'BaseEntity' => '\\dgsoft\\StructType\\DgBaseEntity',
            'ArrayOfValidationError' => '\\dgsoft\\ArrayType\\DgArrayOfValidationError',
            'ValidationError' => '\\dgsoft\\StructType\\DgValidationError',
            'ArrayOfString5' => '\\dgsoft\\ArrayType\\DgArrayOfString5',
            'CrossBoarderSearchSetting' => '\\dgsoft\\StructType\\DgCrossBoarderSearchSetting',
            'PassengerDetails' => '\\dgsoft\\StructType\\DgPassengerDetails',
            'ArrayOfPassengerFlyerCard' => '\\dgsoft\\ArrayType\\DgArrayOfPassengerFlyerCard',
            'PassengerFlyerCard' => '\\dgsoft\\StructType\\DgPassengerFlyerCard',
            'TDESValue' => '\\dgsoft\\StructType\\DgTDESValue',
            'ArrayOfPassengerSpecialRequest' => '\\dgsoft\\ArrayType\\DgArrayOfPassengerSpecialRequest',
            'PassengerSpecialRequest' => '\\dgsoft\\StructType\\DgPassengerSpecialRequest',
            'DocumentDetails' => '\\dgsoft\\StructType\\DgDocumentDetails',
            'ArrayOfDocument' => '\\dgsoft\\ArrayType\\DgArrayOfDocument',
            'ArrayOfDocumentHint' => '\\dgsoft\\ArrayType\\DgArrayOfDocumentHint',
            'DocumentHint' => '\\dgsoft\\StructType\\DgDocumentHint',
            'CommunicationDetails' => '\\dgsoft\\StructType\\DgCommunicationDetails',
            'ArrayOfCommunication' => '\\dgsoft\\ArrayType\\DgArrayOfCommunication',
            'Communication' => '\\dgsoft\\StructType\\DgCommunication',
            'ArrayOfCommunicationHint' => '\\dgsoft\\ArrayType\\DgArrayOfCommunicationHint',
            'CommunicationHint' => '\\dgsoft\\StructType\\DgCommunicationHint',
            'AddressDetails' => '\\dgsoft\\StructType\\DgAddressDetails',
            'ArrayOfAddressDB' => '\\dgsoft\\ArrayType\\DgArrayOfAddressDB',
            'AddressDB' => '\\dgsoft\\StructType\\DgAddressDB',
            'ArrayOfAddressHint' => '\\dgsoft\\ArrayType\\DgArrayOfAddressHint',
            'AddressHint' => '\\dgsoft\\StructType\\DgAddressHint',
            'NameValueItem' => '\\dgsoft\\StructType\\DgNameValueItem',
            'NameValueTypeItem' => '\\dgsoft\\StructType\\DgNameValueTypeItem',
            'Organization' => '\\dgsoft\\StructType\\DgOrganization',
            'ArrayOfOrganization' => '\\dgsoft\\ArrayType\\DgArrayOfOrganization',
            'Corporate' => '\\dgsoft\\StructType\\DgCorporate',
            'ArrayOfCorporateSetting' => '\\dgsoft\\ArrayType\\DgArrayOfCorporateSetting',
            'CorporateSetting' => '\\dgsoft\\StructType\\DgCorporateSetting',
            'ArrayOfQueueSetting' => '\\dgsoft\\ArrayType\\DgArrayOfQueueSetting',
            'QueueSetting' => '\\dgsoft\\StructType\\DgQueueSetting',
            'QueSetting' => '\\dgsoft\\StructType\\DgQueSetting',
            'ArrayOfNameValueTypeItem' => '\\dgsoft\\ArrayType\\DgArrayOfNameValueTypeItem',
            'ArrayOfPassengerDB' => '\\dgsoft\\ArrayType\\DgArrayOfPassengerDB',
            'ArrayOfUser' => '\\dgsoft\\ArrayType\\DgArrayOfUser',
            'OPSProfile' => '\\dgsoft\\StructType\\DgOPSProfile',
            'RegisterUser' => '\\dgsoft\\StructType\\DgRegisterUser',
            'UserOperationsRQ' => '\\dgsoft\\StructType\\DgUserOperationsRQ',
            'RegisterUserResponse' => '\\dgsoft\\StructType\\DgRegisterUserResponse',
            'UpdateUser' => '\\dgsoft\\StructType\\DgUpdateUser',
            'UpdateUserResponse' => '\\dgsoft\\StructType\\DgUpdateUserResponse',
            'GetAPISRules' => '\\dgsoft\\StructType\\DgGetAPISRules',
            'APISRulesRQ' => '\\dgsoft\\StructType\\DgAPISRulesRQ',
            'GetAPISRulesResponse' => '\\dgsoft\\StructType\\DgGetAPISRulesResponse',
            'APISRulesRS' => '\\dgsoft\\StructType\\DgAPISRulesRS',
            'APISRules' => '\\dgsoft\\StructType\\DgAPISRules',
            'APISRuleDocs' => '\\dgsoft\\StructType\\DgAPISRuleDocs',
            'APISRuleDoco' => '\\dgsoft\\StructType\\DgAPISRuleDoco',
            'APISRuleDoca' => '\\dgsoft\\StructType\\DgAPISRuleDoca',
            'GetFlightFareFamilies' => '\\dgsoft\\StructType\\DgGetFlightFareFamilies',
            'FareFamilyInfoRQ' => '\\dgsoft\\StructType\\DgFareFamilyInfoRQ',
            'GetFlightFareFamiliesResponse' => '\\dgsoft\\StructType\\DgGetFlightFareFamiliesResponse',
            'FareFamilyInfoRS' => '\\dgsoft\\StructType\\DgFareFamilyInfoRS',
            'ArrayOfFareFamily' => '\\dgsoft\\ArrayType\\DgArrayOfFareFamily',
            'FareFamily' => '\\dgsoft\\StructType\\DgFareFamily',
            'FlightInfo' => '\\dgsoft\\StructType\\DgFlightInfo',
            'ArrayOfFareFamilyDescription' => '\\dgsoft\\ArrayType\\DgArrayOfFareFamilyDescription',
            'FareFamilyDescription' => '\\dgsoft\\StructType\\DgFareFamilyDescription',
        );
    }
}
