<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWarningType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfWarningType extends AbstractStructArrayBase
{
    /**
     * The WarningType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgWarningType[]
     */
    public $WarningType;
    /**
     * Constructor method for ArrayOfWarningType
     * @uses DgArrayOfWarningType::setWarningType()
     * @param \dgsoft\StructType\DgWarningType[] $warningType
     */
    public function __construct(array $warningType = array())
    {
        $this
            ->setWarningType($warningType);
    }
    /**
     * Get WarningType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgWarningType[]|null
     */
    public function getWarningType()
    {
        return isset($this->WarningType) ? $this->WarningType : null;
    }
    /**
     * Set WarningType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgWarningType[] $warningType
     * @return \dgsoft\ArrayType\DgArrayOfWarningType
     */
    public function setWarningType(array $warningType = array())
    {
        foreach ($warningType as $arrayOfWarningTypeWarningTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfWarningTypeWarningTypeItem instanceof \dgsoft\StructType\DgWarningType) {
                throw new \InvalidArgumentException(sprintf('The WarningType property can only contain items of \dgsoft\StructType\DgWarningType, "%s" given', is_object($arrayOfWarningTypeWarningTypeItem) ? get_class($arrayOfWarningTypeWarningTypeItem) : gettype($arrayOfWarningTypeWarningTypeItem)), __LINE__);
            }
        }
        if (is_null($warningType) || (is_array($warningType) && empty($warningType))) {
            unset($this->WarningType);
        } else {
            $this->WarningType = $warningType;
        }
        return $this;
    }
    /**
     * Add item to WarningType value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgWarningType $item
     * @return \dgsoft\ArrayType\DgArrayOfWarningType
     */
    public function addToWarningType(\dgsoft\StructType\DgWarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgWarningType) {
            throw new \InvalidArgumentException(sprintf('The WarningType property can only contain items of \dgsoft\StructType\DgWarningType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarningType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgWarningType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgWarningType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgWarningType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgWarningType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgWarningType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WarningType
     */
    public function getAttributeName()
    {
        return 'WarningType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfWarningType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
