<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfValidationError ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfValidationError extends AbstractStructArrayBase
{
    /**
     * The ValidationError
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgValidationError[]
     */
    public $ValidationError;
    /**
     * Constructor method for ArrayOfValidationError
     * @uses DgArrayOfValidationError::setValidationError()
     * @param \dgsoft\StructType\DgValidationError[] $validationError
     */
    public function __construct(array $validationError = array())
    {
        $this
            ->setValidationError($validationError);
    }
    /**
     * Get ValidationError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgValidationError[]|null
     */
    public function getValidationError()
    {
        return isset($this->ValidationError) ? $this->ValidationError : null;
    }
    /**
     * Set ValidationError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgValidationError[] $validationError
     * @return \dgsoft\ArrayType\DgArrayOfValidationError
     */
    public function setValidationError(array $validationError = array())
    {
        foreach ($validationError as $arrayOfValidationErrorValidationErrorItem) {
            // validation for constraint: itemType
            if (!$arrayOfValidationErrorValidationErrorItem instanceof \dgsoft\StructType\DgValidationError) {
                throw new \InvalidArgumentException(sprintf('The ValidationError property can only contain items of \dgsoft\StructType\DgValidationError, "%s" given', is_object($arrayOfValidationErrorValidationErrorItem) ? get_class($arrayOfValidationErrorValidationErrorItem) : gettype($arrayOfValidationErrorValidationErrorItem)), __LINE__);
            }
        }
        if (is_null($validationError) || (is_array($validationError) && empty($validationError))) {
            unset($this->ValidationError);
        } else {
            $this->ValidationError = $validationError;
        }
        return $this;
    }
    /**
     * Add item to ValidationError value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgValidationError $item
     * @return \dgsoft\ArrayType\DgArrayOfValidationError
     */
    public function addToValidationError(\dgsoft\StructType\DgValidationError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgValidationError) {
            throw new \InvalidArgumentException(sprintf('The ValidationError property can only contain items of \dgsoft\StructType\DgValidationError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValidationError[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgValidationError|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgValidationError|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgValidationError|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgValidationError|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgValidationError|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ValidationError
     */
    public function getAttributeName()
    {
        return 'ValidationError';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfValidationError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
