<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUser ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfUser extends AbstractStructArrayBase
{
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgUser[]
     */
    public $User;
    /**
     * Constructor method for ArrayOfUser
     * @uses DgArrayOfUser::setUser()
     * @param \dgsoft\StructType\DgUser[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgUser[]|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUser[] $user
     * @return \dgsoft\ArrayType\DgArrayOfUser
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $arrayOfUserUserItem) {
            // validation for constraint: itemType
            if (!$arrayOfUserUserItem instanceof \dgsoft\StructType\DgUser) {
                throw new \InvalidArgumentException(sprintf('The User property can only contain items of \dgsoft\StructType\DgUser, "%s" given', is_object($arrayOfUserUserItem) ? get_class($arrayOfUserUserItem) : gettype($arrayOfUserUserItem)), __LINE__);
            }
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Add item to User value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUser $item
     * @return \dgsoft\ArrayType\DgArrayOfUser
     */
    public function addToUser(\dgsoft\StructType\DgUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUser) {
            throw new \InvalidArgumentException(sprintf('The User property can only contain items of \dgsoft\StructType\DgUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->User[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgUser|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgUser|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgUser|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgUser|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgUser|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string User
     */
    public function getAttributeName()
    {
        return 'User';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
