<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransportationTypeTransportation ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfTransportationTypeTransportation extends AbstractStructArrayBase
{
    /**
     * The Transportation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTransportation[]
     */
    public $Transportation;
    /**
     * Constructor method for ArrayOfTransportationTypeTransportation
     * @uses DgArrayOfTransportationTypeTransportation::setTransportation()
     * @param \dgsoft\StructType\DgTransportation[] $transportation
     */
    public function __construct(array $transportation = array())
    {
        $this
            ->setTransportation($transportation);
    }
    /**
     * Get Transportation value
     * @return \dgsoft\StructType\DgTransportation[]|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * Set Transportation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTransportation[] $transportation
     * @return \dgsoft\ArrayType\DgArrayOfTransportationTypeTransportation
     */
    public function setTransportation(array $transportation = array())
    {
        foreach ($transportation as $arrayOfTransportationTypeTransportationTransportationItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransportationTypeTransportationTransportationItem instanceof \dgsoft\StructType\DgTransportation) {
                throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of \dgsoft\StructType\DgTransportation, "%s" given', is_object($arrayOfTransportationTypeTransportationTransportationItem) ? get_class($arrayOfTransportationTypeTransportationTransportationItem) : gettype($arrayOfTransportationTypeTransportationTransportationItem)), __LINE__);
            }
        }
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Add item to Transportation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTransportation $item
     * @return \dgsoft\ArrayType\DgArrayOfTransportationTypeTransportation
     */
    public function addToTransportation(\dgsoft\StructType\DgTransportation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTransportation) {
            throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of \dgsoft\StructType\DgTransportation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Transportation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgTransportation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgTransportation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgTransportation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgTransportation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgTransportation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Transportation
     */
    public function getAttributeName()
    {
        return 'Transportation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfTransportationTypeTransportation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
