<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString2 ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfString2 extends AbstractStructArrayBase
{
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FareBasisCode;
    /**
     * Constructor method for ArrayOfString2
     * @uses DgArrayOfString2::setFareBasisCode()
     * @param string[] $fareBasisCode
     */
    public function __construct(array $fareBasisCode = array())
    {
        $this
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get FareBasisCode value
     * @return string[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string[] $fareBasisCode
     * @return \dgsoft\ArrayType\DgArrayOfString2
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        foreach ($fareBasisCode as $arrayOfString2FareBasisCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString2FareBasisCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The FareBasisCode property can only contain items of string, "%s" given', is_object($arrayOfString2FareBasisCodeItem) ? get_class($arrayOfString2FareBasisCodeItem) : gettype($arrayOfString2FareBasisCodeItem)), __LINE__);
            }
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfString2
     */
    public function addToFareBasisCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FareBasisCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FareBasisCode
     */
    public function getAttributeName()
    {
        return 'FareBasisCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfString2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
