<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialRequestTypeSpecialRequest ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfSpecialRequestTypeSpecialRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for ArrayOfSpecialRequestTypeSpecialRequest
     * @uses DgArrayOfSpecialRequestTypeSpecialRequest::setSpecialRequest()
     * @param \dgsoft\StructType\DgSpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * @return \dgsoft\StructType\DgSpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * Set SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialRequest[] $specialRequest
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        foreach ($specialRequest as $arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem instanceof \dgsoft\StructType\DgSpecialRequest) {
                throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of \dgsoft\StructType\DgSpecialRequest, "%s" given', is_object($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) ? get_class($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) : gettype($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem)), __LINE__);
            }
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecialRequest $item
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest
     */
    public function addToSpecialRequest(\dgsoft\StructType\DgSpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of \dgsoft\StructType\DgSpecialRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgSpecialRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgSpecialRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgSpecialRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgSpecialRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgSpecialRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialRequest
     */
    public function getAttributeName()
    {
        return 'SpecialRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
