<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialReqDetailsTypeRemark ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfSpecialReqDetailsTypeRemark extends AbstractStructArrayBase
{
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRemark[]
     */
    public $Remark;
    /**
     * Constructor method for ArrayOfSpecialReqDetailsTypeRemark
     * @uses DgArrayOfSpecialReqDetailsTypeRemark::setRemark()
     * @param \dgsoft\StructType\DgRemark[] $remark
     */
    public function __construct(array $remark = array())
    {
        $this
            ->setRemark($remark);
    }
    /**
     * Get Remark value
     * @return \dgsoft\StructType\DgRemark[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRemark[] $remark
     * @return \dgsoft\ArrayType\DgArrayOfSpecialReqDetailsTypeRemark
     */
    public function setRemark(array $remark = array())
    {
        foreach ($remark as $arrayOfSpecialReqDetailsTypeRemarkRemarkItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialReqDetailsTypeRemarkRemarkItem instanceof \dgsoft\StructType\DgRemark) {
                throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of \dgsoft\StructType\DgRemark, "%s" given', is_object($arrayOfSpecialReqDetailsTypeRemarkRemarkItem) ? get_class($arrayOfSpecialReqDetailsTypeRemarkRemarkItem) : gettype($arrayOfSpecialReqDetailsTypeRemarkRemarkItem)), __LINE__);
            }
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRemark $item
     * @return \dgsoft\ArrayType\DgArrayOfSpecialReqDetailsTypeRemark
     */
    public function addToRemark(\dgsoft\StructType\DgRemark $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRemark) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of \dgsoft\StructType\DgRemark, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgRemark|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgRemark|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgRemark|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgRemark|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgRemark|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Remark
     */
    public function getAttributeName()
    {
        return 'Remark';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfSpecialReqDetailsTypeRemark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
