<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSourceType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfSourceType extends AbstractStructArrayBase
{
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSourceType[]
     */
    public $Source;
    /**
     * Constructor method for ArrayOfSourceType
     * @uses DgArrayOfSourceType::setSource()
     * @param \dgsoft\StructType\DgSourceType[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get Source value
     * @return \dgsoft\StructType\DgSourceType[]|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSourceType[] $source
     * @return \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public function setSource(array $source = array())
    {
        foreach ($source as $arrayOfSourceTypeSourceItem) {
            // validation for constraint: itemType
            if (!$arrayOfSourceTypeSourceItem instanceof \dgsoft\StructType\DgSourceType) {
                throw new \InvalidArgumentException(sprintf('The Source property can only contain items of \dgsoft\StructType\DgSourceType, "%s" given', is_object($arrayOfSourceTypeSourceItem) ? get_class($arrayOfSourceTypeSourceItem) : gettype($arrayOfSourceTypeSourceItem)), __LINE__);
            }
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Add item to Source value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSourceType $item
     * @return \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public function addToSource(\dgsoft\StructType\DgSourceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSourceType) {
            throw new \InvalidArgumentException(sprintf('The Source property can only contain items of \dgsoft\StructType\DgSourceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Source[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgSourceType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgSourceType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgSourceType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgSourceType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgSourceType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Source
     */
    public function getAttributeName()
    {
        return 'Source';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
