<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicesTypeService1 ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfServicesTypeService1 extends AbstractStructArrayBase
{
    /**
     * The ServicesTypeService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgServicesTypeService[]
     */
    public $ServicesTypeService;
    /**
     * Constructor method for ArrayOfServicesTypeService1
     * @uses DgArrayOfServicesTypeService1::setServicesTypeService()
     * @param \dgsoft\StructType\DgServicesTypeService[] $servicesTypeService
     */
    public function __construct(array $servicesTypeService = array())
    {
        $this
            ->setServicesTypeService($servicesTypeService);
    }
    /**
     * Get ServicesTypeService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgServicesTypeService[]|null
     */
    public function getServicesTypeService()
    {
        return isset($this->ServicesTypeService) ? $this->ServicesTypeService : null;
    }
    /**
     * Set ServicesTypeService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgServicesTypeService[] $servicesTypeService
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService1
     */
    public function setServicesTypeService(array $servicesTypeService = array())
    {
        foreach ($servicesTypeService as $arrayOfServicesTypeService1ServicesTypeServiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicesTypeService1ServicesTypeServiceItem instanceof \dgsoft\StructType\DgServicesTypeService) {
                throw new \InvalidArgumentException(sprintf('The ServicesTypeService property can only contain items of \dgsoft\StructType\DgServicesTypeService, "%s" given', is_object($arrayOfServicesTypeService1ServicesTypeServiceItem) ? get_class($arrayOfServicesTypeService1ServicesTypeServiceItem) : gettype($arrayOfServicesTypeService1ServicesTypeServiceItem)), __LINE__);
            }
        }
        if (is_null($servicesTypeService) || (is_array($servicesTypeService) && empty($servicesTypeService))) {
            unset($this->ServicesTypeService);
        } else {
            $this->ServicesTypeService = $servicesTypeService;
        }
        return $this;
    }
    /**
     * Add item to ServicesTypeService value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgServicesTypeService $item
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService1
     */
    public function addToServicesTypeService(\dgsoft\StructType\DgServicesTypeService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgServicesTypeService) {
            throw new \InvalidArgumentException(sprintf('The ServicesTypeService property can only contain items of \dgsoft\StructType\DgServicesTypeService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServicesTypeService[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgServicesTypeService|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgServicesTypeService|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgServicesTypeService|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgServicesTypeService|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgServicesTypeService|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServicesTypeService
     */
    public function getAttributeName()
    {
        return 'ServicesTypeService';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
