<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRuleInfos ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfRuleInfos extends AbstractStructArrayBase
{
    /**
     * The RuleInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgRuleInfos[]
     */
    public $RuleInfos;
    /**
     * Constructor method for ArrayOfRuleInfos
     * @uses DgArrayOfRuleInfos::setRuleInfos()
     * @param \dgsoft\StructType\DgRuleInfos[] $ruleInfos
     */
    public function __construct(array $ruleInfos = array())
    {
        $this
            ->setRuleInfos($ruleInfos);
    }
    /**
     * Get RuleInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgRuleInfos[]|null
     */
    public function getRuleInfos()
    {
        return isset($this->RuleInfos) ? $this->RuleInfos : null;
    }
    /**
     * Set RuleInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRuleInfos[] $ruleInfos
     * @return \dgsoft\ArrayType\DgArrayOfRuleInfos
     */
    public function setRuleInfos(array $ruleInfos = array())
    {
        foreach ($ruleInfos as $arrayOfRuleInfosRuleInfosItem) {
            // validation for constraint: itemType
            if (!$arrayOfRuleInfosRuleInfosItem instanceof \dgsoft\StructType\DgRuleInfos) {
                throw new \InvalidArgumentException(sprintf('The RuleInfos property can only contain items of \dgsoft\StructType\DgRuleInfos, "%s" given', is_object($arrayOfRuleInfosRuleInfosItem) ? get_class($arrayOfRuleInfosRuleInfosItem) : gettype($arrayOfRuleInfosRuleInfosItem)), __LINE__);
            }
        }
        if (is_null($ruleInfos) || (is_array($ruleInfos) && empty($ruleInfos))) {
            unset($this->RuleInfos);
        } else {
            $this->RuleInfos = $ruleInfos;
        }
        return $this;
    }
    /**
     * Add item to RuleInfos value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRuleInfos $item
     * @return \dgsoft\ArrayType\DgArrayOfRuleInfos
     */
    public function addToRuleInfos(\dgsoft\StructType\DgRuleInfos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRuleInfos) {
            throw new \InvalidArgumentException(sprintf('The RuleInfos property can only contain items of \dgsoft\StructType\DgRuleInfos, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RuleInfos[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgRuleInfos|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgRuleInfos|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgRuleInfos|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgRuleInfos|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgRuleInfos|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RuleInfos
     */
    public function getAttributeName()
    {
        return 'RuleInfos';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfRuleInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
