<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRowDetailsType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfRowDetailsType extends AbstractStructArrayBase
{
    /**
     * The AirRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRowDetailsType[]
     */
    public $AirRow;
    /**
     * Constructor method for ArrayOfRowDetailsType
     * @uses DgArrayOfRowDetailsType::setAirRow()
     * @param \dgsoft\StructType\DgRowDetailsType[] $airRow
     */
    public function __construct(array $airRow = array())
    {
        $this
            ->setAirRow($airRow);
    }
    /**
     * Get AirRow value
     * @return \dgsoft\StructType\DgRowDetailsType[]|null
     */
    public function getAirRow()
    {
        return $this->AirRow;
    }
    /**
     * Set AirRow value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRowDetailsType[] $airRow
     * @return \dgsoft\ArrayType\DgArrayOfRowDetailsType
     */
    public function setAirRow(array $airRow = array())
    {
        foreach ($airRow as $arrayOfRowDetailsTypeAirRowItem) {
            // validation for constraint: itemType
            if (!$arrayOfRowDetailsTypeAirRowItem instanceof \dgsoft\StructType\DgRowDetailsType) {
                throw new \InvalidArgumentException(sprintf('The AirRow property can only contain items of \dgsoft\StructType\DgRowDetailsType, "%s" given', is_object($arrayOfRowDetailsTypeAirRowItem) ? get_class($arrayOfRowDetailsTypeAirRowItem) : gettype($arrayOfRowDetailsTypeAirRowItem)), __LINE__);
            }
        }
        $this->AirRow = $airRow;
        return $this;
    }
    /**
     * Add item to AirRow value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRowDetailsType $item
     * @return \dgsoft\ArrayType\DgArrayOfRowDetailsType
     */
    public function addToAirRow(\dgsoft\StructType\DgRowDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRowDetailsType) {
            throw new \InvalidArgumentException(sprintf('The AirRow property can only contain items of \dgsoft\StructType\DgRowDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirRow[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgRowDetailsType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgRowDetailsType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgRowDetailsType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgRowDetailsType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgRowDetailsType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AirRow
     */
    public function getAttributeName()
    {
        return 'AirRow';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfRowDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
