<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRequiredParameter ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfRequiredParameter extends AbstractStructArrayBase
{
    /**
     * The RequiredParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgRequiredParameter[]
     */
    public $RequiredParameter;
    /**
     * Constructor method for ArrayOfRequiredParameter
     * @uses DgArrayOfRequiredParameter::setRequiredParameter()
     * @param \dgsoft\StructType\DgRequiredParameter[] $requiredParameter
     */
    public function __construct(array $requiredParameter = array())
    {
        $this
            ->setRequiredParameter($requiredParameter);
    }
    /**
     * Get RequiredParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgRequiredParameter[]|null
     */
    public function getRequiredParameter()
    {
        return isset($this->RequiredParameter) ? $this->RequiredParameter : null;
    }
    /**
     * Set RequiredParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRequiredParameter[] $requiredParameter
     * @return \dgsoft\ArrayType\DgArrayOfRequiredParameter
     */
    public function setRequiredParameter(array $requiredParameter = array())
    {
        foreach ($requiredParameter as $arrayOfRequiredParameterRequiredParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfRequiredParameterRequiredParameterItem instanceof \dgsoft\StructType\DgRequiredParameter) {
                throw new \InvalidArgumentException(sprintf('The RequiredParameter property can only contain items of \dgsoft\StructType\DgRequiredParameter, "%s" given', is_object($arrayOfRequiredParameterRequiredParameterItem) ? get_class($arrayOfRequiredParameterRequiredParameterItem) : gettype($arrayOfRequiredParameterRequiredParameterItem)), __LINE__);
            }
        }
        if (is_null($requiredParameter) || (is_array($requiredParameter) && empty($requiredParameter))) {
            unset($this->RequiredParameter);
        } else {
            $this->RequiredParameter = $requiredParameter;
        }
        return $this;
    }
    /**
     * Add item to RequiredParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRequiredParameter $item
     * @return \dgsoft\ArrayType\DgArrayOfRequiredParameter
     */
    public function addToRequiredParameter(\dgsoft\StructType\DgRequiredParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRequiredParameter) {
            throw new \InvalidArgumentException(sprintf('The RequiredParameter property can only contain items of \dgsoft\StructType\DgRequiredParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RequiredParameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgRequiredParameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgRequiredParameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgRequiredParameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgRequiredParameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgRequiredParameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RequiredParameter
     */
    public function getAttributeName()
    {
        return 'RequiredParameter';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfRequiredParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
