<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPropertyValueMatchTypeAmenity ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfPropertyValueMatchTypeAmenity extends AbstractStructArrayBase
{
    /**
     * The Amenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAmenity[]
     */
    public $Amenity;
    /**
     * Constructor method for ArrayOfPropertyValueMatchTypeAmenity
     * @uses DgArrayOfPropertyValueMatchTypeAmenity::setAmenity()
     * @param \dgsoft\StructType\DgAmenity[] $amenity
     */
    public function __construct(array $amenity = array())
    {
        $this
            ->setAmenity($amenity);
    }
    /**
     * Get Amenity value
     * @return \dgsoft\StructType\DgAmenity[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * Set Amenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAmenity[] $amenity
     * @return \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity
     */
    public function setAmenity(array $amenity = array())
    {
        foreach ($amenity as $arrayOfPropertyValueMatchTypeAmenityAmenityItem) {
            // validation for constraint: itemType
            if (!$arrayOfPropertyValueMatchTypeAmenityAmenityItem instanceof \dgsoft\StructType\DgAmenity) {
                throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of \dgsoft\StructType\DgAmenity, "%s" given', is_object($arrayOfPropertyValueMatchTypeAmenityAmenityItem) ? get_class($arrayOfPropertyValueMatchTypeAmenityAmenityItem) : gettype($arrayOfPropertyValueMatchTypeAmenityAmenityItem)), __LINE__);
            }
        }
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAmenity $item
     * @return \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity
     */
    public function addToAmenity(\dgsoft\StructType\DgAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAmenity) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of \dgsoft\StructType\DgAmenity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgAmenity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgAmenity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgAmenity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgAmenity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgAmenity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Amenity
     */
    public function getAttributeName()
    {
        return 'Amenity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
