<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentDetailType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfPaymentDetailType extends AbstractStructArrayBase
{
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentDetailType[]
     */
    public $PaymentDetail;
    /**
     * Constructor method for ArrayOfPaymentDetailType
     * @uses DgArrayOfPaymentDetailType::setPaymentDetail()
     * @param \dgsoft\StructType\DgPaymentDetailType[] $paymentDetail
     */
    public function __construct(array $paymentDetail = array())
    {
        $this
            ->setPaymentDetail($paymentDetail);
    }
    /**
     * Get PaymentDetail value
     * @return \dgsoft\StructType\DgPaymentDetailType[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentDetailType[] $paymentDetail
     * @return \dgsoft\ArrayType\DgArrayOfPaymentDetailType
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        foreach ($paymentDetail as $arrayOfPaymentDetailTypePaymentDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentDetailTypePaymentDetailItem instanceof \dgsoft\StructType\DgPaymentDetailType) {
                throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of \dgsoft\StructType\DgPaymentDetailType, "%s" given', is_object($arrayOfPaymentDetailTypePaymentDetailItem) ? get_class($arrayOfPaymentDetailTypePaymentDetailItem) : gettype($arrayOfPaymentDetailTypePaymentDetailItem)), __LINE__);
            }
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentDetailType $item
     * @return \dgsoft\ArrayType\DgArrayOfPaymentDetailType
     */
    public function addToPaymentDetail(\dgsoft\StructType\DgPaymentDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentDetailType) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of \dgsoft\StructType\DgPaymentDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgPaymentDetailType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgPaymentDetailType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgPaymentDetailType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgPaymentDetailType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgPaymentDetailType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentDetail
     */
    public function getAttributeName()
    {
        return 'PaymentDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfPaymentDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
