<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPassengerSpecialRequest ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfPassengerSpecialRequest extends AbstractStructArrayBase
{
    /**
     * The PassengerSpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgPassengerSpecialRequest[]
     */
    public $PassengerSpecialRequest;
    /**
     * Constructor method for ArrayOfPassengerSpecialRequest
     * @uses DgArrayOfPassengerSpecialRequest::setPassengerSpecialRequest()
     * @param \dgsoft\StructType\DgPassengerSpecialRequest[] $passengerSpecialRequest
     */
    public function __construct(array $passengerSpecialRequest = array())
    {
        $this
            ->setPassengerSpecialRequest($passengerSpecialRequest);
    }
    /**
     * Get PassengerSpecialRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgPassengerSpecialRequest[]|null
     */
    public function getPassengerSpecialRequest()
    {
        return isset($this->PassengerSpecialRequest) ? $this->PassengerSpecialRequest : null;
    }
    /**
     * Set PassengerSpecialRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerSpecialRequest[] $passengerSpecialRequest
     * @return \dgsoft\ArrayType\DgArrayOfPassengerSpecialRequest
     */
    public function setPassengerSpecialRequest(array $passengerSpecialRequest = array())
    {
        foreach ($passengerSpecialRequest as $arrayOfPassengerSpecialRequestPassengerSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfPassengerSpecialRequestPassengerSpecialRequestItem instanceof \dgsoft\StructType\DgPassengerSpecialRequest) {
                throw new \InvalidArgumentException(sprintf('The PassengerSpecialRequest property can only contain items of \dgsoft\StructType\DgPassengerSpecialRequest, "%s" given', is_object($arrayOfPassengerSpecialRequestPassengerSpecialRequestItem) ? get_class($arrayOfPassengerSpecialRequestPassengerSpecialRequestItem) : gettype($arrayOfPassengerSpecialRequestPassengerSpecialRequestItem)), __LINE__);
            }
        }
        if (is_null($passengerSpecialRequest) || (is_array($passengerSpecialRequest) && empty($passengerSpecialRequest))) {
            unset($this->PassengerSpecialRequest);
        } else {
            $this->PassengerSpecialRequest = $passengerSpecialRequest;
        }
        return $this;
    }
    /**
     * Add item to PassengerSpecialRequest value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPassengerSpecialRequest $item
     * @return \dgsoft\ArrayType\DgArrayOfPassengerSpecialRequest
     */
    public function addToPassengerSpecialRequest(\dgsoft\StructType\DgPassengerSpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPassengerSpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The PassengerSpecialRequest property can only contain items of \dgsoft\StructType\DgPassengerSpecialRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PassengerSpecialRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgPassengerSpecialRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgPassengerSpecialRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgPassengerSpecialRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgPassengerSpecialRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgPassengerSpecialRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PassengerSpecialRequest
     */
    public function getAttributeName()
    {
        return 'PassengerSpecialRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfPassengerSpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
