<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOriginDestinationInformationTypeOriginLocation
 * ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfOriginDestinationInformationTypeOriginLocation extends AbstractStructArrayBase
{
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOriginLocation[]
     */
    public $OriginLocation;
    /**
     * Constructor method for ArrayOfOriginDestinationInformationTypeOriginLocation
     * @uses DgArrayOfOriginDestinationInformationTypeOriginLocation::setOriginLocation()
     * @param \dgsoft\StructType\DgOriginLocation[] $originLocation
     */
    public function __construct(array $originLocation = array())
    {
        $this
            ->setOriginLocation($originLocation);
    }
    /**
     * Get OriginLocation value
     * @return \dgsoft\StructType\DgOriginLocation[]|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOriginLocation[] $originLocation
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationInformationTypeOriginLocation
     */
    public function setOriginLocation(array $originLocation = array())
    {
        foreach ($originLocation as $arrayOfOriginDestinationInformationTypeOriginLocationOriginLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfOriginDestinationInformationTypeOriginLocationOriginLocationItem instanceof \dgsoft\StructType\DgOriginLocation) {
                throw new \InvalidArgumentException(sprintf('The OriginLocation property can only contain items of \dgsoft\StructType\DgOriginLocation, "%s" given', is_object($arrayOfOriginDestinationInformationTypeOriginLocationOriginLocationItem) ? get_class($arrayOfOriginDestinationInformationTypeOriginLocationOriginLocationItem) : gettype($arrayOfOriginDestinationInformationTypeOriginLocationOriginLocationItem)), __LINE__);
            }
        }
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Add item to OriginLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOriginLocation $item
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationInformationTypeOriginLocation
     */
    public function addToOriginLocation(\dgsoft\StructType\DgOriginLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOriginLocation) {
            throw new \InvalidArgumentException(sprintf('The OriginLocation property can only contain items of \dgsoft\StructType\DgOriginLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgOriginLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgOriginLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgOriginLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgOriginLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgOriginLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OriginLocation
     */
    public function getAttributeName()
    {
        return 'OriginLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationInformationTypeOriginLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
