<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNameValueTypeItem ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfNameValueTypeItem extends AbstractStructArrayBase
{
    /**
     * The NameValueTypeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgNameValueTypeItem[]
     */
    public $NameValueTypeItem;
    /**
     * Constructor method for ArrayOfNameValueTypeItem
     * @uses DgArrayOfNameValueTypeItem::setNameValueTypeItem()
     * @param \dgsoft\StructType\DgNameValueTypeItem[] $nameValueTypeItem
     */
    public function __construct(array $nameValueTypeItem = array())
    {
        $this
            ->setNameValueTypeItem($nameValueTypeItem);
    }
    /**
     * Get NameValueTypeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgNameValueTypeItem[]|null
     */
    public function getNameValueTypeItem()
    {
        return isset($this->NameValueTypeItem) ? $this->NameValueTypeItem : null;
    }
    /**
     * Set NameValueTypeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgNameValueTypeItem[] $nameValueTypeItem
     * @return \dgsoft\ArrayType\DgArrayOfNameValueTypeItem
     */
    public function setNameValueTypeItem(array $nameValueTypeItem = array())
    {
        foreach ($nameValueTypeItem as $arrayOfNameValueTypeItemNameValueTypeItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfNameValueTypeItemNameValueTypeItemItem instanceof \dgsoft\StructType\DgNameValueTypeItem) {
                throw new \InvalidArgumentException(sprintf('The NameValueTypeItem property can only contain items of \dgsoft\StructType\DgNameValueTypeItem, "%s" given', is_object($arrayOfNameValueTypeItemNameValueTypeItemItem) ? get_class($arrayOfNameValueTypeItemNameValueTypeItemItem) : gettype($arrayOfNameValueTypeItemNameValueTypeItemItem)), __LINE__);
            }
        }
        if (is_null($nameValueTypeItem) || (is_array($nameValueTypeItem) && empty($nameValueTypeItem))) {
            unset($this->NameValueTypeItem);
        } else {
            $this->NameValueTypeItem = $nameValueTypeItem;
        }
        return $this;
    }
    /**
     * Add item to NameValueTypeItem value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgNameValueTypeItem $item
     * @return \dgsoft\ArrayType\DgArrayOfNameValueTypeItem
     */
    public function addToNameValueTypeItem(\dgsoft\StructType\DgNameValueTypeItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgNameValueTypeItem) {
            throw new \InvalidArgumentException(sprintf('The NameValueTypeItem property can only contain items of \dgsoft\StructType\DgNameValueTypeItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameValueTypeItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgNameValueTypeItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgNameValueTypeItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgNameValueTypeItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgNameValueTypeItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgNameValueTypeItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NameValueTypeItem
     */
    public function getAttributeName()
    {
        return 'NameValueTypeItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfNameValueTypeItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
