<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMembershipTypeMembership ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfMembershipTypeMembership extends AbstractStructArrayBase
{
    /**
     * The Membership
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMembership[]
     */
    public $Membership;
    /**
     * Constructor method for ArrayOfMembershipTypeMembership
     * @uses DgArrayOfMembershipTypeMembership::setMembership()
     * @param \dgsoft\StructType\DgMembership[] $membership
     */
    public function __construct(array $membership = array())
    {
        $this
            ->setMembership($membership);
    }
    /**
     * Get Membership value
     * @return \dgsoft\StructType\DgMembership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMembership[] $membership
     * @return \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership
     */
    public function setMembership(array $membership = array())
    {
        foreach ($membership as $arrayOfMembershipTypeMembershipMembershipItem) {
            // validation for constraint: itemType
            if (!$arrayOfMembershipTypeMembershipMembershipItem instanceof \dgsoft\StructType\DgMembership) {
                throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \dgsoft\StructType\DgMembership, "%s" given', is_object($arrayOfMembershipTypeMembershipMembershipItem) ? get_class($arrayOfMembershipTypeMembershipMembershipItem) : gettype($arrayOfMembershipTypeMembershipMembershipItem)), __LINE__);
            }
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMembership $item
     * @return \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership
     */
    public function addToMembership(\dgsoft\StructType\DgMembership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMembership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \dgsoft\StructType\DgMembership, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgMembership|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgMembership|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgMembership|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgMembership|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgMembership|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Membership
     */
    public function getAttributeName()
    {
        return 'Membership';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfMembershipTypeMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
