<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLastTicketingDateData ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfLastTicketingDateData extends AbstractStructArrayBase
{
    /**
     * The LastTicketingDateData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgLastTicketingDateData[]
     */
    public $LastTicketingDateData;
    /**
     * Constructor method for ArrayOfLastTicketingDateData
     * @uses DgArrayOfLastTicketingDateData::setLastTicketingDateData()
     * @param \dgsoft\StructType\DgLastTicketingDateData[] $lastTicketingDateData
     */
    public function __construct(array $lastTicketingDateData = array())
    {
        $this
            ->setLastTicketingDateData($lastTicketingDateData);
    }
    /**
     * Get LastTicketingDateData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgLastTicketingDateData[]|null
     */
    public function getLastTicketingDateData()
    {
        return isset($this->LastTicketingDateData) ? $this->LastTicketingDateData : null;
    }
    /**
     * Set LastTicketingDateData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLastTicketingDateData[] $lastTicketingDateData
     * @return \dgsoft\ArrayType\DgArrayOfLastTicketingDateData
     */
    public function setLastTicketingDateData(array $lastTicketingDateData = array())
    {
        foreach ($lastTicketingDateData as $arrayOfLastTicketingDateDataLastTicketingDateDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfLastTicketingDateDataLastTicketingDateDataItem instanceof \dgsoft\StructType\DgLastTicketingDateData) {
                throw new \InvalidArgumentException(sprintf('The LastTicketingDateData property can only contain items of \dgsoft\StructType\DgLastTicketingDateData, "%s" given', is_object($arrayOfLastTicketingDateDataLastTicketingDateDataItem) ? get_class($arrayOfLastTicketingDateDataLastTicketingDateDataItem) : gettype($arrayOfLastTicketingDateDataLastTicketingDateDataItem)), __LINE__);
            }
        }
        if (is_null($lastTicketingDateData) || (is_array($lastTicketingDateData) && empty($lastTicketingDateData))) {
            unset($this->LastTicketingDateData);
        } else {
            $this->LastTicketingDateData = $lastTicketingDateData;
        }
        return $this;
    }
    /**
     * Add item to LastTicketingDateData value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLastTicketingDateData $item
     * @return \dgsoft\ArrayType\DgArrayOfLastTicketingDateData
     */
    public function addToLastTicketingDateData(\dgsoft\StructType\DgLastTicketingDateData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLastTicketingDateData) {
            throw new \InvalidArgumentException(sprintf('The LastTicketingDateData property can only contain items of \dgsoft\StructType\DgLastTicketingDateData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LastTicketingDateData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgLastTicketingDateData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgLastTicketingDateData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgLastTicketingDateData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgLastTicketingDateData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgLastTicketingDateData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LastTicketingDateData
     */
    public function getAttributeName()
    {
        return 'LastTicketingDateData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfLastTicketingDateData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
