<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLCCRequiredParameter ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfLCCRequiredParameter extends AbstractStructArrayBase
{
    /**
     * The LCCRequiredParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgLCCRequiredParameter[]
     */
    public $LCCRequiredParameter;
    /**
     * Constructor method for ArrayOfLCCRequiredParameter
     * @uses DgArrayOfLCCRequiredParameter::setLCCRequiredParameter()
     * @param \dgsoft\StructType\DgLCCRequiredParameter[] $lCCRequiredParameter
     */
    public function __construct(array $lCCRequiredParameter = array())
    {
        $this
            ->setLCCRequiredParameter($lCCRequiredParameter);
    }
    /**
     * Get LCCRequiredParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgLCCRequiredParameter[]|null
     */
    public function getLCCRequiredParameter()
    {
        return isset($this->LCCRequiredParameter) ? $this->LCCRequiredParameter : null;
    }
    /**
     * Set LCCRequiredParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLCCRequiredParameter[] $lCCRequiredParameter
     * @return \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter
     */
    public function setLCCRequiredParameter(array $lCCRequiredParameter = array())
    {
        foreach ($lCCRequiredParameter as $arrayOfLCCRequiredParameterLCCRequiredParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfLCCRequiredParameterLCCRequiredParameterItem instanceof \dgsoft\StructType\DgLCCRequiredParameter) {
                throw new \InvalidArgumentException(sprintf('The LCCRequiredParameter property can only contain items of \dgsoft\StructType\DgLCCRequiredParameter, "%s" given', is_object($arrayOfLCCRequiredParameterLCCRequiredParameterItem) ? get_class($arrayOfLCCRequiredParameterLCCRequiredParameterItem) : gettype($arrayOfLCCRequiredParameterLCCRequiredParameterItem)), __LINE__);
            }
        }
        if (is_null($lCCRequiredParameter) || (is_array($lCCRequiredParameter) && empty($lCCRequiredParameter))) {
            unset($this->LCCRequiredParameter);
        } else {
            $this->LCCRequiredParameter = $lCCRequiredParameter;
        }
        return $this;
    }
    /**
     * Add item to LCCRequiredParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLCCRequiredParameter $item
     * @return \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter
     */
    public function addToLCCRequiredParameter(\dgsoft\StructType\DgLCCRequiredParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLCCRequiredParameter) {
            throw new \InvalidArgumentException(sprintf('The LCCRequiredParameter property can only contain items of \dgsoft\StructType\DgLCCRequiredParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LCCRequiredParameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgLCCRequiredParameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgLCCRequiredParameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgLCCRequiredParameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgLCCRequiredParameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgLCCRequiredParameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LCCRequiredParameter
     */
    public function getAttributeName()
    {
        return 'LCCRequiredParameter';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
