<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupDetailType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfGroupDetailType extends AbstractStructArrayBase
{
    /**
     * The GroupDetailType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgGroupDetailType[]
     */
    public $GroupDetailType;
    /**
     * Constructor method for ArrayOfGroupDetailType
     * @uses DgArrayOfGroupDetailType::setGroupDetailType()
     * @param \dgsoft\StructType\DgGroupDetailType[] $groupDetailType
     */
    public function __construct(array $groupDetailType = array())
    {
        $this
            ->setGroupDetailType($groupDetailType);
    }
    /**
     * Get GroupDetailType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgGroupDetailType[]|null
     */
    public function getGroupDetailType()
    {
        return isset($this->GroupDetailType) ? $this->GroupDetailType : null;
    }
    /**
     * Set GroupDetailType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgGroupDetailType[] $groupDetailType
     * @return \dgsoft\ArrayType\DgArrayOfGroupDetailType
     */
    public function setGroupDetailType(array $groupDetailType = array())
    {
        foreach ($groupDetailType as $arrayOfGroupDetailTypeGroupDetailTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupDetailTypeGroupDetailTypeItem instanceof \dgsoft\StructType\DgGroupDetailType) {
                throw new \InvalidArgumentException(sprintf('The GroupDetailType property can only contain items of \dgsoft\StructType\DgGroupDetailType, "%s" given', is_object($arrayOfGroupDetailTypeGroupDetailTypeItem) ? get_class($arrayOfGroupDetailTypeGroupDetailTypeItem) : gettype($arrayOfGroupDetailTypeGroupDetailTypeItem)), __LINE__);
            }
        }
        if (is_null($groupDetailType) || (is_array($groupDetailType) && empty($groupDetailType))) {
            unset($this->GroupDetailType);
        } else {
            $this->GroupDetailType = $groupDetailType;
        }
        return $this;
    }
    /**
     * Add item to GroupDetailType value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgGroupDetailType $item
     * @return \dgsoft\ArrayType\DgArrayOfGroupDetailType
     */
    public function addToGroupDetailType(\dgsoft\StructType\DgGroupDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgGroupDetailType) {
            throw new \InvalidArgumentException(sprintf('The GroupDetailType property can only contain items of \dgsoft\StructType\DgGroupDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupDetailType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgGroupDetailType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgGroupDetailType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgGroupDetailType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgGroupDetailType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgGroupDetailType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupDetailType
     */
    public function getAttributeName()
    {
        return 'GroupDetailType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfGroupDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
