<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentHint ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfDocumentHint extends AbstractStructArrayBase
{
    /**
     * The DocumentHint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgDocumentHint[]
     */
    public $DocumentHint;
    /**
     * Constructor method for ArrayOfDocumentHint
     * @uses DgArrayOfDocumentHint::setDocumentHint()
     * @param \dgsoft\StructType\DgDocumentHint[] $documentHint
     */
    public function __construct(array $documentHint = array())
    {
        $this
            ->setDocumentHint($documentHint);
    }
    /**
     * Get DocumentHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgDocumentHint[]|null
     */
    public function getDocumentHint()
    {
        return isset($this->DocumentHint) ? $this->DocumentHint : null;
    }
    /**
     * Set DocumentHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocumentHint[] $documentHint
     * @return \dgsoft\ArrayType\DgArrayOfDocumentHint
     */
    public function setDocumentHint(array $documentHint = array())
    {
        foreach ($documentHint as $arrayOfDocumentHintDocumentHintItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentHintDocumentHintItem instanceof \dgsoft\StructType\DgDocumentHint) {
                throw new \InvalidArgumentException(sprintf('The DocumentHint property can only contain items of \dgsoft\StructType\DgDocumentHint, "%s" given', is_object($arrayOfDocumentHintDocumentHintItem) ? get_class($arrayOfDocumentHintDocumentHintItem) : gettype($arrayOfDocumentHintDocumentHintItem)), __LINE__);
            }
        }
        if (is_null($documentHint) || (is_array($documentHint) && empty($documentHint))) {
            unset($this->DocumentHint);
        } else {
            $this->DocumentHint = $documentHint;
        }
        return $this;
    }
    /**
     * Add item to DocumentHint value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocumentHint $item
     * @return \dgsoft\ArrayType\DgArrayOfDocumentHint
     */
    public function addToDocumentHint(\dgsoft\StructType\DgDocumentHint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDocumentHint) {
            throw new \InvalidArgumentException(sprintf('The DocumentHint property can only contain items of \dgsoft\StructType\DgDocumentHint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocumentHint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgDocumentHint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgDocumentHint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgDocumentHint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgDocumentHint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgDocumentHint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentHint
     */
    public function getAttributeName()
    {
        return 'DocumentHint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfDocumentHint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
