<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDateTime ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfDateTime extends AbstractStructArrayBase
{
    /**
     * The dateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $dateTime;
    /**
     * Constructor method for ArrayOfDateTime
     * @uses DgArrayOfDateTime::setDateTime()
     * @param string[] $dateTime
     */
    public function __construct(array $dateTime = array())
    {
        $this
            ->setDateTime($dateTime);
    }
    /**
     * Get dateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDateTime()
    {
        return isset($this->dateTime) ? $this->dateTime : null;
    }
    /**
     * Set dateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $dateTime
     * @return \dgsoft\ArrayType\DgArrayOfDateTime
     */
    public function setDateTime(array $dateTime = array())
    {
        foreach ($dateTime as $arrayOfDateTimeDateTimeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfDateTimeDateTimeItem)) {
                throw new \InvalidArgumentException(sprintf('The dateTime property can only contain items of dateTime, "%s" given', is_object($arrayOfDateTimeDateTimeItem) ? get_class($arrayOfDateTimeDateTimeItem) : gettype($arrayOfDateTimeDateTimeItem)), __LINE__);
            }
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->dateTime);
        } else {
            $this->dateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Add item to dateTime value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\ArrayType\DgArrayOfDateTime
     */
    public function addToDateTime($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The dateTime property can only contain items of dateTime, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dateTime[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string dateTime
     */
    public function getAttributeName()
    {
        return 'dateTime';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfDateTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
