<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConnectionTypeConnectionLocation ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfConnectionTypeConnectionLocation extends AbstractStructArrayBase
{
    /**
     * The ConnectionLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgConnectionLocation[]
     */
    public $ConnectionLocation;
    /**
     * Constructor method for ArrayOfConnectionTypeConnectionLocation
     * @uses DgArrayOfConnectionTypeConnectionLocation::setConnectionLocation()
     * @param \dgsoft\StructType\DgConnectionLocation[] $connectionLocation
     */
    public function __construct(array $connectionLocation = array())
    {
        $this
            ->setConnectionLocation($connectionLocation);
    }
    /**
     * Get ConnectionLocation value
     * @return \dgsoft\StructType\DgConnectionLocation[]|null
     */
    public function getConnectionLocation()
    {
        return $this->ConnectionLocation;
    }
    /**
     * Set ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgConnectionLocation[] $connectionLocation
     * @return \dgsoft\ArrayType\DgArrayOfConnectionTypeConnectionLocation
     */
    public function setConnectionLocation(array $connectionLocation = array())
    {
        foreach ($connectionLocation as $arrayOfConnectionTypeConnectionLocationConnectionLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfConnectionTypeConnectionLocationConnectionLocationItem instanceof \dgsoft\StructType\DgConnectionLocation) {
                throw new \InvalidArgumentException(sprintf('The ConnectionLocation property can only contain items of \dgsoft\StructType\DgConnectionLocation, "%s" given', is_object($arrayOfConnectionTypeConnectionLocationConnectionLocationItem) ? get_class($arrayOfConnectionTypeConnectionLocationConnectionLocationItem) : gettype($arrayOfConnectionTypeConnectionLocationConnectionLocationItem)), __LINE__);
            }
        }
        $this->ConnectionLocation = $connectionLocation;
        return $this;
    }
    /**
     * Add item to ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgConnectionLocation $item
     * @return \dgsoft\ArrayType\DgArrayOfConnectionTypeConnectionLocation
     */
    public function addToConnectionLocation(\dgsoft\StructType\DgConnectionLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgConnectionLocation) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLocation property can only contain items of \dgsoft\StructType\DgConnectionLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgConnectionLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgConnectionLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgConnectionLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgConnectionLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgConnectionLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ConnectionLocation
     */
    public function getAttributeName()
    {
        return 'ConnectionLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfConnectionTypeConnectionLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
