<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommentTypeComment ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfCommentTypeComment extends AbstractStructArrayBase
{
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgComment[]
     */
    public $Comment;
    /**
     * Constructor method for ArrayOfCommentTypeComment
     * @uses DgArrayOfCommentTypeComment::setComment()
     * @param \dgsoft\StructType\DgComment[] $comment
     */
    public function __construct(array $comment = array())
    {
        $this
            ->setComment($comment);
    }
    /**
     * Get Comment value
     * @return \dgsoft\StructType\DgComment[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgComment[] $comment
     * @return \dgsoft\ArrayType\DgArrayOfCommentTypeComment
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $arrayOfCommentTypeCommentCommentItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommentTypeCommentCommentItem instanceof \dgsoft\StructType\DgComment) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgComment, "%s" given', is_object($arrayOfCommentTypeCommentCommentItem) ? get_class($arrayOfCommentTypeCommentCommentItem) : gettype($arrayOfCommentTypeCommentCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgComment $item
     * @return \dgsoft\ArrayType\DgArrayOfCommentTypeComment
     */
    public function addToComment(\dgsoft\StructType\DgComment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgComment) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgComment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgComment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgComment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgComment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgComment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgComment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Comment
     */
    public function getAttributeName()
    {
        return 'Comment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfCommentTypeComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
