<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfColumnDetailsType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfColumnDetailsType extends AbstractStructArrayBase
{
    /**
     * The AirColumn
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgColumnDetailsType[]
     */
    public $AirColumn;
    /**
     * Constructor method for ArrayOfColumnDetailsType
     * @uses DgArrayOfColumnDetailsType::setAirColumn()
     * @param \dgsoft\StructType\DgColumnDetailsType[] $airColumn
     */
    public function __construct(array $airColumn = array())
    {
        $this
            ->setAirColumn($airColumn);
    }
    /**
     * Get AirColumn value
     * @return \dgsoft\StructType\DgColumnDetailsType[]|null
     */
    public function getAirColumn()
    {
        return $this->AirColumn;
    }
    /**
     * Set AirColumn value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgColumnDetailsType[] $airColumn
     * @return \dgsoft\ArrayType\DgArrayOfColumnDetailsType
     */
    public function setAirColumn(array $airColumn = array())
    {
        foreach ($airColumn as $arrayOfColumnDetailsTypeAirColumnItem) {
            // validation for constraint: itemType
            if (!$arrayOfColumnDetailsTypeAirColumnItem instanceof \dgsoft\StructType\DgColumnDetailsType) {
                throw new \InvalidArgumentException(sprintf('The AirColumn property can only contain items of \dgsoft\StructType\DgColumnDetailsType, "%s" given', is_object($arrayOfColumnDetailsTypeAirColumnItem) ? get_class($arrayOfColumnDetailsTypeAirColumnItem) : gettype($arrayOfColumnDetailsTypeAirColumnItem)), __LINE__);
            }
        }
        $this->AirColumn = $airColumn;
        return $this;
    }
    /**
     * Add item to AirColumn value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgColumnDetailsType $item
     * @return \dgsoft\ArrayType\DgArrayOfColumnDetailsType
     */
    public function addToAirColumn(\dgsoft\StructType\DgColumnDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgColumnDetailsType) {
            throw new \InvalidArgumentException(sprintf('The AirColumn property can only contain items of \dgsoft\StructType\DgColumnDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirColumn[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgColumnDetailsType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgColumnDetailsType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgColumnDetailsType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgColumnDetailsType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgColumnDetailsType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AirColumn
     */
    public function getAttributeName()
    {
        return 'AirColumn';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfColumnDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
