<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAirTaxType ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfAirTaxType extends AbstractStructArrayBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirTaxType[]
     */
    public $Tax;
    /**
     * Constructor method for ArrayOfAirTaxType
     * @uses DgArrayOfAirTaxType::setTax()
     * @param \dgsoft\StructType\DgAirTaxType[] $tax
     */
    public function __construct(array $tax = array())
    {
        $this
            ->setTax($tax);
    }
    /**
     * Get Tax value
     * @return \dgsoft\StructType\DgAirTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirTaxType[] $tax
     * @return \dgsoft\ArrayType\DgArrayOfAirTaxType
     */
    public function setTax(array $tax = array())
    {
        foreach ($tax as $arrayOfAirTaxTypeTaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfAirTaxTypeTaxItem instanceof \dgsoft\StructType\DgAirTaxType) {
                throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of \dgsoft\StructType\DgAirTaxType, "%s" given', is_object($arrayOfAirTaxTypeTaxItem) ? get_class($arrayOfAirTaxTypeTaxItem) : gettype($arrayOfAirTaxTypeTaxItem)), __LINE__);
            }
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirTaxType $item
     * @return \dgsoft\ArrayType\DgArrayOfAirTaxType
     */
    public function addToTax(\dgsoft\StructType\DgAirTaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAirTaxType) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of \dgsoft\StructType\DgAirTaxType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgAirTaxType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgAirTaxType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgAirTaxType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgAirTaxType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgAirTaxType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Tax
     */
    public function getAttributeName()
    {
        return 'Tax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfAirTaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
