<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAirReservationTypeQueue ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfAirReservationTypeQueue extends AbstractStructArrayBase
{
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueue[]
     */
    public $Queue;
    /**
     * Constructor method for ArrayOfAirReservationTypeQueue
     * @uses DgArrayOfAirReservationTypeQueue::setQueue()
     * @param \dgsoft\StructType\DgQueue[] $queue
     */
    public function __construct(array $queue = array())
    {
        $this
            ->setQueue($queue);
    }
    /**
     * Get Queue value
     * @return \dgsoft\StructType\DgQueue[]|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgQueue[] $queue
     * @return \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue
     */
    public function setQueue(array $queue = array())
    {
        foreach ($queue as $arrayOfAirReservationTypeQueueQueueItem) {
            // validation for constraint: itemType
            if (!$arrayOfAirReservationTypeQueueQueueItem instanceof \dgsoft\StructType\DgQueue) {
                throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of \dgsoft\StructType\DgQueue, "%s" given', is_object($arrayOfAirReservationTypeQueueQueueItem) ? get_class($arrayOfAirReservationTypeQueueQueueItem) : gettype($arrayOfAirReservationTypeQueueQueueItem)), __LINE__);
            }
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Add item to Queue value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgQueue $item
     * @return \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue
     */
    public function addToQueue(\dgsoft\StructType\DgQueue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgQueue) {
            throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of \dgsoft\StructType\DgQueue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Queue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Queue
     */
    public function getAttributeName()
    {
        return 'Queue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfAirReservationTypeQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
