<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressHint ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfAddressHint extends AbstractStructArrayBase
{
    /**
     * The AddressHint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgAddressHint[]
     */
    public $AddressHint;
    /**
     * Constructor method for ArrayOfAddressHint
     * @uses DgArrayOfAddressHint::setAddressHint()
     * @param \dgsoft\StructType\DgAddressHint[] $addressHint
     */
    public function __construct(array $addressHint = array())
    {
        $this
            ->setAddressHint($addressHint);
    }
    /**
     * Get AddressHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgAddressHint[]|null
     */
    public function getAddressHint()
    {
        return isset($this->AddressHint) ? $this->AddressHint : null;
    }
    /**
     * Set AddressHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressHint[] $addressHint
     * @return \dgsoft\ArrayType\DgArrayOfAddressHint
     */
    public function setAddressHint(array $addressHint = array())
    {
        foreach ($addressHint as $arrayOfAddressHintAddressHintItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressHintAddressHintItem instanceof \dgsoft\StructType\DgAddressHint) {
                throw new \InvalidArgumentException(sprintf('The AddressHint property can only contain items of \dgsoft\StructType\DgAddressHint, "%s" given', is_object($arrayOfAddressHintAddressHintItem) ? get_class($arrayOfAddressHintAddressHintItem) : gettype($arrayOfAddressHintAddressHintItem)), __LINE__);
            }
        }
        if (is_null($addressHint) || (is_array($addressHint) && empty($addressHint))) {
            unset($this->AddressHint);
        } else {
            $this->AddressHint = $addressHint;
        }
        return $this;
    }
    /**
     * Add item to AddressHint value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressHint $item
     * @return \dgsoft\ArrayType\DgArrayOfAddressHint
     */
    public function addToAddressHint(\dgsoft\StructType\DgAddressHint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressHint) {
            throw new \InvalidArgumentException(sprintf('The AddressHint property can only contain items of \dgsoft\StructType\DgAddressHint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressHint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgAddressHint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgAddressHint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgAddressHint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgAddressHint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgAddressHint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressHint
     */
    public function getAttributeName()
    {
        return 'AddressHint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfAddressHint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
