<?php

namespace dgsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressDB ArrayType
 * @package Dg
 * @subpackage Arrays
 */
class DgArrayOfAddressDB extends AbstractStructArrayBase
{
    /**
     * The AddressDB
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \dgsoft\StructType\DgAddressDB[]
     */
    public $AddressDB;
    /**
     * Constructor method for ArrayOfAddressDB
     * @uses DgArrayOfAddressDB::setAddressDB()
     * @param \dgsoft\StructType\DgAddressDB[] $addressDB
     */
    public function __construct(array $addressDB = array())
    {
        $this
            ->setAddressDB($addressDB);
    }
    /**
     * Get AddressDB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \dgsoft\StructType\DgAddressDB[]|null
     */
    public function getAddressDB()
    {
        return isset($this->AddressDB) ? $this->AddressDB : null;
    }
    /**
     * Set AddressDB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressDB[] $addressDB
     * @return \dgsoft\ArrayType\DgArrayOfAddressDB
     */
    public function setAddressDB(array $addressDB = array())
    {
        foreach ($addressDB as $arrayOfAddressDBAddressDBItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressDBAddressDBItem instanceof \dgsoft\StructType\DgAddressDB) {
                throw new \InvalidArgumentException(sprintf('The AddressDB property can only contain items of \dgsoft\StructType\DgAddressDB, "%s" given', is_object($arrayOfAddressDBAddressDBItem) ? get_class($arrayOfAddressDBAddressDBItem) : gettype($arrayOfAddressDBAddressDBItem)), __LINE__);
            }
        }
        if (is_null($addressDB) || (is_array($addressDB) && empty($addressDB))) {
            unset($this->AddressDB);
        } else {
            $this->AddressDB = $addressDB;
        }
        return $this;
    }
    /**
     * Add item to AddressDB value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressDB $item
     * @return \dgsoft\ArrayType\DgArrayOfAddressDB
     */
    public function addToAddressDB(\dgsoft\StructType\DgAddressDB $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressDB) {
            throw new \InvalidArgumentException(sprintf('The AddressDB property can only contain items of \dgsoft\StructType\DgAddressDB, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressDB[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \dgsoft\StructType\DgAddressDB|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \dgsoft\StructType\DgAddressDB|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \dgsoft\StructType\DgAddressDB|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \dgsoft\StructType\DgAddressDB|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \dgsoft\StructType\DgAddressDB|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressDB
     */
    public function getAttributeName()
    {
        return 'AddressDB';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\ArrayType\DgArrayOfAddressDB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
