<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType StructType
 * @subpackage Structs
 */
class ResponseType extends AbstractStructBase
{
    /**
     * The RequestStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:RequestStatus
     * @var string
     */
    public $RequestStatus;
    /**
     * The Catalogue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:Catalogue
     * @var string
     */
    public $Catalogue;
    /**
     * The DateGenerated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateGenerated;
    /**
     * Constructor method for ResponseType
     * @uses ResponseType::setRequestStatus()
     * @uses ResponseType::setCatalogue()
     * @uses ResponseType::setDateGenerated()
     * @param string $requestStatus
     * @param string $catalogue
     * @param string $dateGenerated
     */
    public function __construct($requestStatus = null, $catalogue = null, $dateGenerated = null)
    {
        $this
            ->setRequestStatus($requestStatus)
            ->setCatalogue($catalogue)
            ->setDateGenerated($dateGenerated);
    }
    /**
     * Get RequestStatus value
     * @return string|null
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @uses \EnumType\RequestStatus::valueIsValid()
     * @uses \EnumType\RequestStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestStatus
     * @return \StructType\ResponseType
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestStatus::valueIsValid($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestStatus, implode(', ', \EnumType\RequestStatus::getValidValues())), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get Catalogue value
     * @return string|null
     */
    public function getCatalogue()
    {
        return $this->Catalogue;
    }
    /**
     * Set Catalogue value
     * @param string $catalogue
     * @return \StructType\ResponseType
     */
    public function setCatalogue($catalogue = null)
    {
        // validation for constraint: string
        if (!is_null($catalogue) && !is_string($catalogue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($catalogue)), __LINE__);
        }
        $this->Catalogue = $catalogue;
        return $this;
    }
    /**
     * Get DateGenerated value
     * @return string|null
     */
    public function getDateGenerated()
    {
        return $this->DateGenerated;
    }
    /**
     * Set DateGenerated value
     * @param string $dateGenerated
     * @return \StructType\ResponseType
     */
    public function setDateGenerated($dateGenerated = null)
    {
        // validation for constraint: string
        if (!is_null($dateGenerated) && !is_string($dateGenerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateGenerated)), __LINE__);
        }
        $this->DateGenerated = $dateGenerated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
