<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTerm StructType
 * @subpackage Structs
 */
class PaymentTerm extends AbstractStructBase
{
    /**
     * The PaymentTermCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTermCode;
    /**
     * The PaymentTermDateCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTermDateCode;
    /**
     * The DiscountPercent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DiscountPercent;
    /**
     * The DiscountPercentDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DiscountPercentDueDate;
    /**
     * The DiscountPercentDaysDue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DiscountPercentDaysDue;
    /**
     * The NetDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NetDueDate;
    /**
     * The NetDaysDue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NetDaysDue;
    /**
     * The DiscountAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DiscountAmount;
    /**
     * The DiscountDescriptionEn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DiscountDescriptionEn;
    /**
     * The DiscountDescriptionFr
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DiscountDescriptionFr;
    /**
     * Constructor method for PaymentTerm
     * @uses PaymentTerm::setPaymentTermCode()
     * @uses PaymentTerm::setPaymentTermDateCode()
     * @uses PaymentTerm::setDiscountPercent()
     * @uses PaymentTerm::setDiscountPercentDueDate()
     * @uses PaymentTerm::setDiscountPercentDaysDue()
     * @uses PaymentTerm::setNetDueDate()
     * @uses PaymentTerm::setNetDaysDue()
     * @uses PaymentTerm::setDiscountAmount()
     * @uses PaymentTerm::setDiscountDescriptionEn()
     * @uses PaymentTerm::setDiscountDescriptionFr()
     * @param string $paymentTermCode
     * @param string $paymentTermDateCode
     * @param float $discountPercent
     * @param string $discountPercentDueDate
     * @param int $discountPercentDaysDue
     * @param string $netDueDate
     * @param string $netDaysDue
     * @param float $discountAmount
     * @param string $discountDescriptionEn
     * @param string $discountDescriptionFr
     */
    public function __construct($paymentTermCode = null, $paymentTermDateCode = null, $discountPercent = null, $discountPercentDueDate = null, $discountPercentDaysDue = null, $netDueDate = null, $netDaysDue = null, $discountAmount = null, $discountDescriptionEn = null, $discountDescriptionFr = null)
    {
        $this
            ->setPaymentTermCode($paymentTermCode)
            ->setPaymentTermDateCode($paymentTermDateCode)
            ->setDiscountPercent($discountPercent)
            ->setDiscountPercentDueDate($discountPercentDueDate)
            ->setDiscountPercentDaysDue($discountPercentDaysDue)
            ->setNetDueDate($netDueDate)
            ->setNetDaysDue($netDaysDue)
            ->setDiscountAmount($discountAmount)
            ->setDiscountDescriptionEn($discountDescriptionEn)
            ->setDiscountDescriptionFr($discountDescriptionFr);
    }
    /**
     * Get PaymentTermCode value
     * @return string|null
     */
    public function getPaymentTermCode()
    {
        return $this->PaymentTermCode;
    }
    /**
     * Set PaymentTermCode value
     * @param string $paymentTermCode
     * @return \StructType\PaymentTerm
     */
    public function setPaymentTermCode($paymentTermCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermCode) && !is_string($paymentTermCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTermCode)), __LINE__);
        }
        $this->PaymentTermCode = $paymentTermCode;
        return $this;
    }
    /**
     * Get PaymentTermDateCode value
     * @return string|null
     */
    public function getPaymentTermDateCode()
    {
        return $this->PaymentTermDateCode;
    }
    /**
     * Set PaymentTermDateCode value
     * @param string $paymentTermDateCode
     * @return \StructType\PaymentTerm
     */
    public function setPaymentTermDateCode($paymentTermDateCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermDateCode) && !is_string($paymentTermDateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTermDateCode)), __LINE__);
        }
        $this->PaymentTermDateCode = $paymentTermDateCode;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\PaymentTerm
     */
    public function setDiscountPercent($discountPercent = null)
    {
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get DiscountPercentDueDate value
     * @return string|null
     */
    public function getDiscountPercentDueDate()
    {
        return $this->DiscountPercentDueDate;
    }
    /**
     * Set DiscountPercentDueDate value
     * @param string $discountPercentDueDate
     * @return \StructType\PaymentTerm
     */
    public function setDiscountPercentDueDate($discountPercentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountPercentDueDate) && !is_string($discountPercentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountPercentDueDate)), __LINE__);
        }
        $this->DiscountPercentDueDate = $discountPercentDueDate;
        return $this;
    }
    /**
     * Get DiscountPercentDaysDue value
     * @return int|null
     */
    public function getDiscountPercentDaysDue()
    {
        return $this->DiscountPercentDaysDue;
    }
    /**
     * Set DiscountPercentDaysDue value
     * @param int $discountPercentDaysDue
     * @return \StructType\PaymentTerm
     */
    public function setDiscountPercentDaysDue($discountPercentDaysDue = null)
    {
        // validation for constraint: int
        if (!is_null($discountPercentDaysDue) && !is_numeric($discountPercentDaysDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($discountPercentDaysDue)), __LINE__);
        }
        $this->DiscountPercentDaysDue = $discountPercentDaysDue;
        return $this;
    }
    /**
     * Get NetDueDate value
     * @return string|null
     */
    public function getNetDueDate()
    {
        return $this->NetDueDate;
    }
    /**
     * Set NetDueDate value
     * @param string $netDueDate
     * @return \StructType\PaymentTerm
     */
    public function setNetDueDate($netDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($netDueDate) && !is_string($netDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($netDueDate)), __LINE__);
        }
        $this->NetDueDate = $netDueDate;
        return $this;
    }
    /**
     * Get NetDaysDue value
     * @return string|null
     */
    public function getNetDaysDue()
    {
        return $this->NetDaysDue;
    }
    /**
     * Set NetDaysDue value
     * @param string $netDaysDue
     * @return \StructType\PaymentTerm
     */
    public function setNetDaysDue($netDaysDue = null)
    {
        // validation for constraint: string
        if (!is_null($netDaysDue) && !is_string($netDaysDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($netDaysDue)), __LINE__);
        }
        $this->NetDaysDue = $netDaysDue;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \StructType\PaymentTerm
     */
    public function setDiscountAmount($discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountDescriptionEn value
     * @return string|null
     */
    public function getDiscountDescriptionEn()
    {
        return $this->DiscountDescriptionEn;
    }
    /**
     * Set DiscountDescriptionEn value
     * @param string $discountDescriptionEn
     * @return \StructType\PaymentTerm
     */
    public function setDiscountDescriptionEn($discountDescriptionEn = null)
    {
        // validation for constraint: string
        if (!is_null($discountDescriptionEn) && !is_string($discountDescriptionEn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountDescriptionEn)), __LINE__);
        }
        $this->DiscountDescriptionEn = $discountDescriptionEn;
        return $this;
    }
    /**
     * Get DiscountDescriptionFr value
     * @return string|null
     */
    public function getDiscountDescriptionFr()
    {
        return $this->DiscountDescriptionFr;
    }
    /**
     * Set DiscountDescriptionFr value
     * @param string $discountDescriptionFr
     * @return \StructType\PaymentTerm
     */
    public function setDiscountDescriptionFr($discountDescriptionFr = null)
    {
        // validation for constraint: string
        if (!is_null($discountDescriptionFr) && !is_string($discountDescriptionFr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountDescriptionFr)), __LINE__);
        }
        $this->DiscountDescriptionFr = $discountDescriptionFr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentTerm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
