<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parties StructType
 * @subpackage Structs
 */
class Parties extends AbstractStructBase
{
    /**
     * The Party
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Party[]
     */
    public $Party;
    /**
     * Constructor method for Parties
     * @uses Parties::setParty()
     * @param \StructType\Party[] $party
     */
    public function __construct(array $party = array())
    {
        $this
            ->setParty($party);
    }
    /**
     * Get Party value
     * @return \StructType\Party[]|null
     */
    public function getParty()
    {
        return $this->Party;
    }
    /**
     * Set Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party[] $party
     * @return \StructType\Parties
     */
    public function setParty(array $party = array())
    {
        foreach ($party as $partiesPartyItem) {
            // validation for constraint: itemType
            if (!$partiesPartyItem instanceof \StructType\Party) {
                throw new \InvalidArgumentException(sprintf('The Party property can only contain items of \StructType\Party, "%s" given', is_object($partiesPartyItem) ? get_class($partiesPartyItem) : gettype($partiesPartyItem)), __LINE__);
            }
        }
        $this->Party = $party;
        return $this;
    }
    /**
     * Add item to Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party $item
     * @return \StructType\Parties
     */
    public function addToParty(\StructType\Party $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Party) {
            throw new \InvalidArgumentException(sprintf('The Party property can only contain items of \StructType\Party, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Party[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Parties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
