<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInformation StructType
 * @subpackage Structs
 */
class InvoiceInformation extends AbstractStructBase
{
    /**
     * The CustomerNumber
     * @var int
     */
    public $CustomerNumber;
    /**
     * The DistributorIdentifier
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * @var string
     */
    public $DistributorIdentifier;
    /**
     * The InvoiceNumber
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * Constructor method for InvoiceInformation
     * @uses InvoiceInformation::setCustomerNumber()
     * @uses InvoiceInformation::setDistributorIdentifier()
     * @uses InvoiceInformation::setInvoiceNumber()
     * @uses InvoiceInformation::setInvoiceDate()
     * @param int $customerNumber
     * @param string $distributorIdentifier
     * @param int $invoiceNumber
     * @param string $invoiceDate
     */
    public function __construct($customerNumber = null, $distributorIdentifier = null, $invoiceNumber = null, $invoiceDate = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setDistributorIdentifier($distributorIdentifier)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate);
    }
    /**
     * Get CustomerNumber value
     * @return int|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\InvoiceInformation
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !is_numeric($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get DistributorIdentifier value
     * @return string|null
     */
    public function getDistributorIdentifier()
    {
        return $this->DistributorIdentifier;
    }
    /**
     * Set DistributorIdentifier value
     * @param string $distributorIdentifier
     * @return \StructType\InvoiceInformation
     */
    public function setDistributorIdentifier($distributorIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($distributorIdentifier) && !is_string($distributorIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributorIdentifier)), __LINE__);
        }
        $this->DistributorIdentifier = $distributorIdentifier;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \StructType\InvoiceInformation
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !is_numeric($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\InvoiceInformation
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
