<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoice ServiceType
 * @subpackage Services
 */
class Invoice extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named invoiceByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvoiceRequestByDate $invoiceRequestByDate
     * @return \StructType\InvoiceResponse|bool
     */
    public function invoiceByDate(\StructType\InvoiceRequestByDate $invoiceRequestByDate)
    {
        try {
            $this->setResult(self::getSoapClient()->invoiceByDate($invoiceRequestByDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
