<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Information StructType
 * @subpackage Structs
 */
class Information extends AbstractStructBase
{
    /**
     * The InvoiceDownload
     * @var \StructType\InvoiceDownload
     */
    public $InvoiceDownload;
    /**
     * The CustomerNumber
     * Meta informations extracted from the WSDL
     * - ref: ns2:CustomerNumber
     * @var int
     */
    public $CustomerNumber;
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - ref: ns2:Format
     * @var string
     */
    public $Format;
    /**
     * Constructor method for Information
     * @uses Information::setInvoiceDownload()
     * @uses Information::setCustomerNumber()
     * @uses Information::setFormat()
     * @param \StructType\InvoiceDownload $invoiceDownload
     * @param int $customerNumber
     * @param string $format
     */
    public function __construct(\StructType\InvoiceDownload $invoiceDownload = null, $customerNumber = null, $format = null)
    {
        $this
            ->setInvoiceDownload($invoiceDownload)
            ->setCustomerNumber($customerNumber)
            ->setFormat($format);
    }
    /**
     * Get InvoiceDownload value
     * @return \StructType\InvoiceDownload|null
     */
    public function getInvoiceDownload()
    {
        return $this->InvoiceDownload;
    }
    /**
     * Set InvoiceDownload value
     * @param \StructType\InvoiceDownload $invoiceDownload
     * @return \StructType\Information
     */
    public function setInvoiceDownload(\StructType\InvoiceDownload $invoiceDownload = null)
    {
        $this->InvoiceDownload = $invoiceDownload;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return int|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\Information
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !is_numeric($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\Information
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Information
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
