<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fault_type StructType
 * @subpackage Structs
 */
class Fault_type extends AbstractStructBase
{
    /**
     * The faultCode
     * @var string
     */
    public $faultCode;
    /**
     * The faultType
     * @var string
     */
    public $faultType;
    /**
     * The faultMessage
     * @var string
     */
    public $faultMessage;
    /**
     * Constructor method for Fault_type
     * @uses Fault_type::setFaultCode()
     * @uses Fault_type::setFaultType()
     * @uses Fault_type::setFaultMessage()
     * @param string $faultCode
     * @param string $faultType
     * @param string $faultMessage
     */
    public function __construct($faultCode = null, $faultType = null, $faultMessage = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultType($faultType)
            ->setFaultMessage($faultMessage);
    }
    /**
     * Get faultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->faultCode;
    }
    /**
     * Set faultCode value
     * @param string $faultCode
     * @return \StructType\Fault_type
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultCode)), __LINE__);
        }
        $this->faultCode = $faultCode;
        return $this;
    }
    /**
     * Get faultType value
     * @return string|null
     */
    public function getFaultType()
    {
        return $this->faultType;
    }
    /**
     * Set faultType value
     * @param string $faultType
     * @return \StructType\Fault_type
     */
    public function setFaultType($faultType = null)
    {
        // validation for constraint: string
        if (!is_null($faultType) && !is_string($faultType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultType)), __LINE__);
        }
        $this->faultType = $faultType;
        return $this;
    }
    /**
     * Get faultMessage value
     * @return string|null
     */
    public function getFaultMessage()
    {
        return $this->faultMessage;
    }
    /**
     * Set faultMessage value
     * @param string $faultMessage
     * @return \StructType\Fault_type
     */
    public function setFaultMessage($faultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($faultMessage) && !is_string($faultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultMessage)), __LINE__);
        }
        $this->faultMessage = $faultMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fault_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
