<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CatalogueRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * @subpackage Structs
 */
class CatalogueRequest extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta informations extracted from the WSDL
     * - ref: ns2:Authentication
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The Information
     * Meta informations extracted from the WSDL
     * - ref: ns2:Information
     * @var \StructType\Information
     */
    public $Information;
    /**
     * Constructor method for CatalogueRequest
     * @uses CatalogueRequest::setAuthentication()
     * @uses CatalogueRequest::setInformation()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Information $information
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\Information $information = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setInformation($information);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\CatalogueRequest
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get Information value
     * @return \StructType\Information|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * Set Information value
     * @param \StructType\Information $information
     * @return \StructType\CatalogueRequest
     */
    public function setInformation(\StructType\Information $information = null)
    {
        $this->Information = $information;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CatalogueRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
