<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippedItem StructType
 * @subpackage Structs
 */
class ShippedItem extends AbstractStructBase
{
    /**
     * The ItemNumber
     * @var int
     */
    public $ItemNumber;
    /**
     * The ItemDescriptionEn
     * @var string
     */
    public $ItemDescriptionEn;
    /**
     * The ItemDescriptionFr
     * @var string
     */
    public $ItemDescriptionFr;
    /**
     * The ShippedQuantity
     * @var int
     */
    public $ShippedQuantity;
    /**
     * The ShippedUnitOfMeasure
     * @var string
     */
    public $ShippedUnitOfMeasure;
    /**
     * The InvoicedQuantity
     * @var int
     */
    public $InvoicedQuantity;
    /**
     * The InvoicedUnitOfMeasure
     * @var string
     */
    public $InvoicedUnitOfMeasure;
    /**
     * The Price
     * @var float
     */
    public $Price;
    /**
     * The GTINS
     * @var \StructType\GTINS
     */
    public $GTINS;
    /**
     * The ContainerNumber
     * @var string
     */
    public $ContainerNumber;
    /**
     * The GoodsAndServicesTaxCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GoodsAndServicesTaxCode;
    /**
     * The GoodsAndServicesTaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: D=DETAXE / TAX REFUND E=EXONERE / DISCLAIMS T=TAXABLE / TAXABLE
     * - minOccurs: 0
     * @var float
     */
    public $GoodsAndServicesTaxAmount;
    /**
     * The ProvincialTaxCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProvincialTaxCode;
    /**
     * The ProvincialTaxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ProvincialTaxAmount;
    /**
     * The QuantityPerCase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuantityPerCase;
    /**
     * The QuantityPerPack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuantityPerPack;
    /**
     * The ExtendedSellingPrice
     * @var float
     */
    public $ExtendedSellingPrice;
    /**
     * The AllowanceCharges
     * @var \StructType\AllowanceCharges
     */
    public $AllowanceCharges;
    /**
     * Constructor method for ShippedItem
     * @uses ShippedItem::setItemNumber()
     * @uses ShippedItem::setItemDescriptionEn()
     * @uses ShippedItem::setItemDescriptionFr()
     * @uses ShippedItem::setShippedQuantity()
     * @uses ShippedItem::setShippedUnitOfMeasure()
     * @uses ShippedItem::setInvoicedQuantity()
     * @uses ShippedItem::setInvoicedUnitOfMeasure()
     * @uses ShippedItem::setPrice()
     * @uses ShippedItem::setGTINS()
     * @uses ShippedItem::setContainerNumber()
     * @uses ShippedItem::setGoodsAndServicesTaxCode()
     * @uses ShippedItem::setGoodsAndServicesTaxAmount()
     * @uses ShippedItem::setProvincialTaxCode()
     * @uses ShippedItem::setProvincialTaxAmount()
     * @uses ShippedItem::setQuantityPerCase()
     * @uses ShippedItem::setQuantityPerPack()
     * @uses ShippedItem::setExtendedSellingPrice()
     * @uses ShippedItem::setAllowanceCharges()
     * @param int $itemNumber
     * @param string $itemDescriptionEn
     * @param string $itemDescriptionFr
     * @param int $shippedQuantity
     * @param string $shippedUnitOfMeasure
     * @param int $invoicedQuantity
     * @param string $invoicedUnitOfMeasure
     * @param float $price
     * @param \StructType\GTINS $gTINS
     * @param string $containerNumber
     * @param string $goodsAndServicesTaxCode
     * @param float $goodsAndServicesTaxAmount
     * @param string $provincialTaxCode
     * @param float $provincialTaxAmount
     * @param int $quantityPerCase
     * @param int $quantityPerPack
     * @param float $extendedSellingPrice
     * @param \StructType\AllowanceCharges $allowanceCharges
     */
    public function __construct($itemNumber = null, $itemDescriptionEn = null, $itemDescriptionFr = null, $shippedQuantity = null, $shippedUnitOfMeasure = null, $invoicedQuantity = null, $invoicedUnitOfMeasure = null, $price = null, \StructType\GTINS $gTINS = null, $containerNumber = null, $goodsAndServicesTaxCode = null, $goodsAndServicesTaxAmount = null, $provincialTaxCode = null, $provincialTaxAmount = null, $quantityPerCase = null, $quantityPerPack = null, $extendedSellingPrice = null, \StructType\AllowanceCharges $allowanceCharges = null)
    {
        $this
            ->setItemNumber($itemNumber)
            ->setItemDescriptionEn($itemDescriptionEn)
            ->setItemDescriptionFr($itemDescriptionFr)
            ->setShippedQuantity($shippedQuantity)
            ->setShippedUnitOfMeasure($shippedUnitOfMeasure)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setInvoicedUnitOfMeasure($invoicedUnitOfMeasure)
            ->setPrice($price)
            ->setGTINS($gTINS)
            ->setContainerNumber($containerNumber)
            ->setGoodsAndServicesTaxCode($goodsAndServicesTaxCode)
            ->setGoodsAndServicesTaxAmount($goodsAndServicesTaxAmount)
            ->setProvincialTaxCode($provincialTaxCode)
            ->setProvincialTaxAmount($provincialTaxAmount)
            ->setQuantityPerCase($quantityPerCase)
            ->setQuantityPerPack($quantityPerPack)
            ->setExtendedSellingPrice($extendedSellingPrice)
            ->setAllowanceCharges($allowanceCharges);
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \StructType\ShippedItem
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !is_numeric($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get ItemDescriptionEn value
     * @return string|null
     */
    public function getItemDescriptionEn()
    {
        return $this->ItemDescriptionEn;
    }
    /**
     * Set ItemDescriptionEn value
     * @param string $itemDescriptionEn
     * @return \StructType\ShippedItem
     */
    public function setItemDescriptionEn($itemDescriptionEn = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescriptionEn) && !is_string($itemDescriptionEn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescriptionEn)), __LINE__);
        }
        $this->ItemDescriptionEn = $itemDescriptionEn;
        return $this;
    }
    /**
     * Get ItemDescriptionFr value
     * @return string|null
     */
    public function getItemDescriptionFr()
    {
        return $this->ItemDescriptionFr;
    }
    /**
     * Set ItemDescriptionFr value
     * @param string $itemDescriptionFr
     * @return \StructType\ShippedItem
     */
    public function setItemDescriptionFr($itemDescriptionFr = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescriptionFr) && !is_string($itemDescriptionFr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescriptionFr)), __LINE__);
        }
        $this->ItemDescriptionFr = $itemDescriptionFr;
        return $this;
    }
    /**
     * Get ShippedQuantity value
     * @return int|null
     */
    public function getShippedQuantity()
    {
        return $this->ShippedQuantity;
    }
    /**
     * Set ShippedQuantity value
     * @param int $shippedQuantity
     * @return \StructType\ShippedItem
     */
    public function setShippedQuantity($shippedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($shippedQuantity) && !is_numeric($shippedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shippedQuantity)), __LINE__);
        }
        $this->ShippedQuantity = $shippedQuantity;
        return $this;
    }
    /**
     * Get ShippedUnitOfMeasure value
     * @return string|null
     */
    public function getShippedUnitOfMeasure()
    {
        return $this->ShippedUnitOfMeasure;
    }
    /**
     * Set ShippedUnitOfMeasure value
     * @param string $shippedUnitOfMeasure
     * @return \StructType\ShippedItem
     */
    public function setShippedUnitOfMeasure($shippedUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($shippedUnitOfMeasure) && !is_string($shippedUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippedUnitOfMeasure)), __LINE__);
        }
        $this->ShippedUnitOfMeasure = $shippedUnitOfMeasure;
        return $this;
    }
    /**
     * Get InvoicedQuantity value
     * @return int|null
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }
    /**
     * Set InvoicedQuantity value
     * @param int $invoicedQuantity
     * @return \StructType\ShippedItem
     */
    public function setInvoicedQuantity($invoicedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($invoicedQuantity) && !is_numeric($invoicedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoicedQuantity)), __LINE__);
        }
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get InvoicedUnitOfMeasure value
     * @return string|null
     */
    public function getInvoicedUnitOfMeasure()
    {
        return $this->InvoicedUnitOfMeasure;
    }
    /**
     * Set InvoicedUnitOfMeasure value
     * @param string $invoicedUnitOfMeasure
     * @return \StructType\ShippedItem
     */
    public function setInvoicedUnitOfMeasure($invoicedUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($invoicedUnitOfMeasure) && !is_string($invoicedUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoicedUnitOfMeasure)), __LINE__);
        }
        $this->InvoicedUnitOfMeasure = $invoicedUnitOfMeasure;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\ShippedItem
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get GTINS value
     * @return \StructType\GTINS|null
     */
    public function getGTINS()
    {
        return $this->GTINS;
    }
    /**
     * Set GTINS value
     * @param \StructType\GTINS $gTINS
     * @return \StructType\ShippedItem
     */
    public function setGTINS(\StructType\GTINS $gTINS = null)
    {
        $this->GTINS = $gTINS;
        return $this;
    }
    /**
     * Get ContainerNumber value
     * @return string|null
     */
    public function getContainerNumber()
    {
        return $this->ContainerNumber;
    }
    /**
     * Set ContainerNumber value
     * @param string $containerNumber
     * @return \StructType\ShippedItem
     */
    public function setContainerNumber($containerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($containerNumber) && !is_string($containerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($containerNumber)), __LINE__);
        }
        $this->ContainerNumber = $containerNumber;
        return $this;
    }
    /**
     * Get GoodsAndServicesTaxCode value
     * @return string|null
     */
    public function getGoodsAndServicesTaxCode()
    {
        return $this->GoodsAndServicesTaxCode;
    }
    /**
     * Set GoodsAndServicesTaxCode value
     * @param string $goodsAndServicesTaxCode
     * @return \StructType\ShippedItem
     */
    public function setGoodsAndServicesTaxCode($goodsAndServicesTaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($goodsAndServicesTaxCode) && !is_string($goodsAndServicesTaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodsAndServicesTaxCode)), __LINE__);
        }
        $this->GoodsAndServicesTaxCode = $goodsAndServicesTaxCode;
        return $this;
    }
    /**
     * Get GoodsAndServicesTaxAmount value
     * @return float|null
     */
    public function getGoodsAndServicesTaxAmount()
    {
        return $this->GoodsAndServicesTaxAmount;
    }
    /**
     * Set GoodsAndServicesTaxAmount value
     * @param float $goodsAndServicesTaxAmount
     * @return \StructType\ShippedItem
     */
    public function setGoodsAndServicesTaxAmount($goodsAndServicesTaxAmount = null)
    {
        $this->GoodsAndServicesTaxAmount = $goodsAndServicesTaxAmount;
        return $this;
    }
    /**
     * Get ProvincialTaxCode value
     * @return string|null
     */
    public function getProvincialTaxCode()
    {
        return $this->ProvincialTaxCode;
    }
    /**
     * Set ProvincialTaxCode value
     * @param string $provincialTaxCode
     * @return \StructType\ShippedItem
     */
    public function setProvincialTaxCode($provincialTaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($provincialTaxCode) && !is_string($provincialTaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provincialTaxCode)), __LINE__);
        }
        $this->ProvincialTaxCode = $provincialTaxCode;
        return $this;
    }
    /**
     * Get ProvincialTaxAmount value
     * @return float|null
     */
    public function getProvincialTaxAmount()
    {
        return $this->ProvincialTaxAmount;
    }
    /**
     * Set ProvincialTaxAmount value
     * @param float $provincialTaxAmount
     * @return \StructType\ShippedItem
     */
    public function setProvincialTaxAmount($provincialTaxAmount = null)
    {
        $this->ProvincialTaxAmount = $provincialTaxAmount;
        return $this;
    }
    /**
     * Get QuantityPerCase value
     * @return int|null
     */
    public function getQuantityPerCase()
    {
        return $this->QuantityPerCase;
    }
    /**
     * Set QuantityPerCase value
     * @param int $quantityPerCase
     * @return \StructType\ShippedItem
     */
    public function setQuantityPerCase($quantityPerCase = null)
    {
        // validation for constraint: int
        if (!is_null($quantityPerCase) && !is_numeric($quantityPerCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantityPerCase)), __LINE__);
        }
        $this->QuantityPerCase = $quantityPerCase;
        return $this;
    }
    /**
     * Get QuantityPerPack value
     * @return int|null
     */
    public function getQuantityPerPack()
    {
        return $this->QuantityPerPack;
    }
    /**
     * Set QuantityPerPack value
     * @param int $quantityPerPack
     * @return \StructType\ShippedItem
     */
    public function setQuantityPerPack($quantityPerPack = null)
    {
        // validation for constraint: int
        if (!is_null($quantityPerPack) && !is_numeric($quantityPerPack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantityPerPack)), __LINE__);
        }
        $this->QuantityPerPack = $quantityPerPack;
        return $this;
    }
    /**
     * Get ExtendedSellingPrice value
     * @return float|null
     */
    public function getExtendedSellingPrice()
    {
        return $this->ExtendedSellingPrice;
    }
    /**
     * Set ExtendedSellingPrice value
     * @param float $extendedSellingPrice
     * @return \StructType\ShippedItem
     */
    public function setExtendedSellingPrice($extendedSellingPrice = null)
    {
        $this->ExtendedSellingPrice = $extendedSellingPrice;
        return $this;
    }
    /**
     * Get AllowanceCharges value
     * @return \StructType\AllowanceCharges|null
     */
    public function getAllowanceCharges()
    {
        return $this->AllowanceCharges;
    }
    /**
     * Set AllowanceCharges value
     * @param \StructType\AllowanceCharges $allowanceCharges
     * @return \StructType\ShippedItem
     */
    public function setAllowanceCharges(\StructType\AllowanceCharges $allowanceCharges = null)
    {
        $this->AllowanceCharges = $allowanceCharges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
