<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The ResponseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ns2:ResponseType
     * @var \StructType\ResponseType[]
     */
    public $ResponseType;
    /**
     * Constructor method for Response
     * @uses Response::setResponseType()
     * @param \StructType\ResponseType[] $responseType
     */
    public function __construct(array $responseType = array())
    {
        $this
            ->setResponseType($responseType);
    }
    /**
     * Get ResponseType value
     * @return \StructType\ResponseType[]|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseType[] $responseType
     * @return \StructType\Response
     */
    public function setResponseType(array $responseType = array())
    {
        foreach ($responseType as $responseResponseTypeItem) {
            // validation for constraint: itemType
            if (!$responseResponseTypeItem instanceof \StructType\ResponseType) {
                throw new \InvalidArgumentException(sprintf('The ResponseType property can only contain items of \StructType\ResponseType, "%s" given', is_object($responseResponseTypeItem) ? get_class($responseResponseTypeItem) : gettype($responseResponseTypeItem)), __LINE__);
            }
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Add item to ResponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseType $item
     * @return \StructType\Response
     */
    public function addToResponseType(\StructType\ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResponseType) {
            throw new \InvalidArgumentException(sprintf('The ResponseType property can only contain items of \StructType\ResponseType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ResponseType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
