<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestAll StructType
 * @subpackage Structs
 */
class RequestAll extends AbstractStructBase
{
    /**
     * The CustomerNumber
     * @var int
     */
    public $CustomerNumber;
    /**
     * The DistributorIdentifier
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * @var string
     */
    public $DistributorIdentifier;
    /**
     * Constructor method for RequestAll
     * @uses RequestAll::setCustomerNumber()
     * @uses RequestAll::setDistributorIdentifier()
     * @param int $customerNumber
     * @param string $distributorIdentifier
     */
    public function __construct($customerNumber = null, $distributorIdentifier = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setDistributorIdentifier($distributorIdentifier);
    }
    /**
     * Get CustomerNumber value
     * @return int|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\RequestAll
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !is_numeric($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get DistributorIdentifier value
     * @return string|null
     */
    public function getDistributorIdentifier()
    {
        return $this->DistributorIdentifier;
    }
    /**
     * Set DistributorIdentifier value
     * @param string $distributorIdentifier
     * @return \StructType\RequestAll
     */
    public function setDistributorIdentifier($distributorIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($distributorIdentifier) && !is_string($distributorIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributorIdentifier)), __LINE__);
        }
        $this->DistributorIdentifier = $distributorIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestAll
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
