<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInformation_type StructType
 * @subpackage Structs
 */
class OrderInformation_type extends AbstractStructBase
{
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - ref: ns1:Header
     * @var \StructType\Header_type
     */
    public $Header;
    /**
     * The PromotionInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PromotionInformation_type
     */
    public $PromotionInformation;
    /**
     * The ItemInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ItemInformation_type[]
     */
    public $ItemInformation;
    /**
     * Constructor method for OrderInformation_type
     * @uses OrderInformation_type::setHeader()
     * @uses OrderInformation_type::setPromotionInformation()
     * @uses OrderInformation_type::setItemInformation()
     * @param \StructType\Header_type $header
     * @param \StructType\PromotionInformation_type $promotionInformation
     * @param \StructType\ItemInformation_type[] $itemInformation
     */
    public function __construct(\StructType\Header_type $header = null, \StructType\PromotionInformation_type $promotionInformation = null, array $itemInformation = array())
    {
        $this
            ->setHeader($header)
            ->setPromotionInformation($promotionInformation)
            ->setItemInformation($itemInformation);
    }
    /**
     * Get Header value
     * @return \StructType\Header_type|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \StructType\Header_type $header
     * @return \StructType\OrderInformation_type
     */
    public function setHeader(\StructType\Header_type $header = null)
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Get PromotionInformation value
     * @return \StructType\PromotionInformation_type|null
     */
    public function getPromotionInformation()
    {
        return $this->PromotionInformation;
    }
    /**
     * Set PromotionInformation value
     * @param \StructType\PromotionInformation_type $promotionInformation
     * @return \StructType\OrderInformation_type
     */
    public function setPromotionInformation(\StructType\PromotionInformation_type $promotionInformation = null)
    {
        $this->PromotionInformation = $promotionInformation;
        return $this;
    }
    /**
     * Get ItemInformation value
     * @return \StructType\ItemInformation_type[]|null
     */
    public function getItemInformation()
    {
        return $this->ItemInformation;
    }
    /**
     * Set ItemInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInformation_type[] $itemInformation
     * @return \StructType\OrderInformation_type
     */
    public function setItemInformation(array $itemInformation = array())
    {
        foreach ($itemInformation as $orderInformation_typeItemInformationItem) {
            // validation for constraint: itemType
            if (!$orderInformation_typeItemInformationItem instanceof \StructType\ItemInformation_type) {
                throw new \InvalidArgumentException(sprintf('The ItemInformation property can only contain items of \StructType\ItemInformation_type, "%s" given', is_object($orderInformation_typeItemInformationItem) ? get_class($orderInformation_typeItemInformationItem) : gettype($orderInformation_typeItemInformationItem)), __LINE__);
            }
        }
        $this->ItemInformation = $itemInformation;
        return $this;
    }
    /**
     * Add item to ItemInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInformation_type $item
     * @return \StructType\OrderInformation_type
     */
    public function addToItemInformation(\StructType\ItemInformation_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemInformation_type) {
            throw new \InvalidArgumentException(sprintf('The ItemInformation property can only contain items of \StructType\ItemInformation_type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemInformation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderInformation_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
