<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInformation_type StructType
 * @subpackage Structs
 */
class ItemInformation_type extends AbstractStructBase
{
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LineNumber;
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - maxLength: 25
     * @var string
     */
    public $ItemID;
    /**
     * The ItemIDType
     * @var string
     */
    public $ItemIDType;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Modality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Modality;
    /**
     * Constructor method for ItemInformation_type
     * @uses ItemInformation_type::setLineNumber()
     * @uses ItemInformation_type::setItemID()
     * @uses ItemInformation_type::setItemIDType()
     * @uses ItemInformation_type::setQuantity()
     * @uses ItemInformation_type::setModality()
     * @param int $lineNumber
     * @param string $itemID
     * @param string $itemIDType
     * @param int $quantity
     * @param string $modality
     */
    public function __construct($lineNumber = null, $itemID = null, $itemIDType = null, $quantity = null, $modality = null)
    {
        $this
            ->setLineNumber($lineNumber)
            ->setItemID($itemID)
            ->setItemIDType($itemIDType)
            ->setQuantity($quantity)
            ->setModality($modality);
    }
    /**
     * Get LineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \StructType\ItemInformation_type
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !is_numeric($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \StructType\ItemInformation_type
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itemID) && strlen($itemID) > 25) || (is_array($itemID) && count($itemID) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($itemID) ? strlen($itemID) : count($itemID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get ItemIDType value
     * @return string|null
     */
    public function getItemIDType()
    {
        return $this->ItemIDType;
    }
    /**
     * Set ItemIDType value
     * @uses \EnumType\ItemIDType::valueIsValid()
     * @uses \EnumType\ItemIDType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemIDType
     * @return \StructType\ItemInformation_type
     */
    public function setItemIDType($itemIDType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemIDType::valueIsValid($itemIDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $itemIDType, implode(', ', \EnumType\ItemIDType::getValidValues())), __LINE__);
        }
        $this->ItemIDType = $itemIDType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ItemInformation_type
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Modality value
     * @return string|null
     */
    public function getModality()
    {
        return $this->Modality;
    }
    /**
     * Set Modality value
     * @uses \EnumType\Modality::valueIsValid()
     * @uses \EnumType\Modality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modality
     * @return \StructType\ItemInformation_type
     */
    public function setModality($modality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Modality::valueIsValid($modality)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $modality, implode(', ', \EnumType\Modality::getValidValues())), __LINE__);
        }
        $this->Modality = $modality;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemInformation_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
