<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GTINS StructType
 * @subpackage Structs
 */
class GTINS extends AbstractStructBase
{
    /**
     * The GTIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GTIN[]
     */
    public $GTIN;
    /**
     * Constructor method for GTINS
     * @uses GTINS::setGTIN()
     * @param \StructType\GTIN[] $gTIN
     */
    public function __construct(array $gTIN = array())
    {
        $this
            ->setGTIN($gTIN);
    }
    /**
     * Get GTIN value
     * @return \StructType\GTIN[]|null
     */
    public function getGTIN()
    {
        return $this->GTIN;
    }
    /**
     * Set GTIN value
     * @throws \InvalidArgumentException
     * @param \StructType\GTIN[] $gTIN
     * @return \StructType\GTINS
     */
    public function setGTIN(array $gTIN = array())
    {
        foreach ($gTIN as $gTINSGTINItem) {
            // validation for constraint: itemType
            if (!$gTINSGTINItem instanceof \StructType\GTIN) {
                throw new \InvalidArgumentException(sprintf('The GTIN property can only contain items of \StructType\GTIN, "%s" given', is_object($gTINSGTINItem) ? get_class($gTINSGTINItem) : gettype($gTINSGTINItem)), __LINE__);
            }
        }
        $this->GTIN = $gTIN;
        return $this;
    }
    /**
     * Add item to GTIN value
     * @throws \InvalidArgumentException
     * @param \StructType\GTIN $item
     * @return \StructType\GTINS
     */
    public function addToGTIN(\StructType\GTIN $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GTIN) {
            throw new \InvalidArgumentException(sprintf('The GTIN property can only contain items of \StructType\GTIN, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GTIN[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GTINS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
