<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationFault StructType
 * @subpackage Structs
 */
class AuthenticationFault extends AbstractStructBase
{
    /**
     * The FaultCode
     * @var string
     */
    public $FaultCode;
    /**
     * The FaultMessage
     * @var string
     */
    public $FaultMessage;
    /**
     * Constructor method for AuthenticationFault
     * @uses AuthenticationFault::setFaultCode()
     * @uses AuthenticationFault::setFaultMessage()
     * @param string $faultCode
     * @param string $faultMessage
     */
    public function __construct($faultCode = null, $faultMessage = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultMessage($faultMessage);
    }
    /**
     * Get FaultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->FaultCode;
    }
    /**
     * Set FaultCode value
     * @uses \EnumType\FaultCode::valueIsValid()
     * @uses \EnumType\FaultCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $faultCode
     * @return \StructType\AuthenticationFault
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FaultCode::valueIsValid($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $faultCode, implode(', ', \EnumType\FaultCode::getValidValues())), __LINE__);
        }
        $this->FaultCode = $faultCode;
        return $this;
    }
    /**
     * Get FaultMessage value
     * @return string|null
     */
    public function getFaultMessage()
    {
        return $this->FaultMessage;
    }
    /**
     * Set FaultMessage value
     * @param string $faultMessage
     * @return \StructType\AuthenticationFault
     */
    public function setFaultMessage($faultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($faultMessage) && !is_string($faultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultMessage)), __LINE__);
        }
        $this->FaultMessage = $faultMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticationFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
