<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Action StructType
 * @subpackage Structs
 */
class Action extends AbstractStructBase
{
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The Action_Type
     * @var string
     */
    public $Action_Type;
    /**
     * The RequestType
     * @var string
     */
    public $RequestType;
    /**
     * Constructor method for Action
     * @uses Action::setActionType()
     * @uses Action::setAction_Type()
     * @uses Action::setRequestType()
     * @param string $actionType
     * @param string $action_Type
     * @param string $requestType
     */
    public function __construct($actionType = null, $action_Type = null, $requestType = null)
    {
        $this
            ->setActionType($actionType)
            ->setAction_Type($action_Type)
            ->setRequestType($requestType);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @param string $actionType
     * @return \StructType\Action
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionType)), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get Action_Type value
     * @return string|null
     */
    public function getAction_Type()
    {
        return $this->Action_Type;
    }
    /**
     * Set Action_Type value
     * @param string $action_Type
     * @return \StructType\Action
     */
    public function setAction_Type($action_Type = null)
    {
        // validation for constraint: string
        if (!is_null($action_Type) && !is_string($action_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action_Type)), __LINE__);
        }
        $this->Action_Type = $action_Type;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @param string $requestType
     * @return \StructType\Action
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Action
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
